/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.canvas.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.iu.uits.lms.canvas.model.BlueprintAssociatedCourse;
import edu.iu.uits.lms.canvas.model.BlueprintCourseUpdateStatus;
import edu.iu.uits.lms.canvas.model.BlueprintMigration;
import edu.iu.uits.lms.canvas.model.BlueprintMigrationStatus;
import edu.iu.uits.lms.canvas.model.BlueprintRestriction;
import edu.iu.uits.lms.canvas.model.BlueprintSubscription;
import edu.iu.uits.lms.canvas.model.BlueprintTemplate;
import edu.iu.uits.lms.canvas.model.BlueprintUpdateStatus;
import edu.iu.uits.lms.canvas.model.Course;
import edu.iu.uits.lms.canvas.services.SpringBaseService;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

@Service
public class BlueprintService
extends SpringBaseService {
    private static final Logger log = LoggerFactory.getLogger(BlueprintService.class);
    private String BASE_URI = "{url}/courses/{course_id}";
    private String BLUEPRINT_URI = this.BASE_URI + "/blueprint_templates/{template_id}";
    private String BLUEPRINT_SUBSCRIPTIONS_BASE_URI = this.BASE_URI + "/blueprint_subscriptions";
    private String BLUEPRINT_SUBSCRIPTIONS_URI = this.BLUEPRINT_SUBSCRIPTIONS_BASE_URI + "/{template_id}";
    private UriTemplate GET_BY_COURSE_AND_TEMPLATE = new UriTemplate(this.BLUEPRINT_URI);
    private UriTemplate GET_COURSES = new UriTemplate(this.BLUEPRINT_URI + "/associated_courses");
    private UriTemplate UPDATE_BP_COURSES = new UriTemplate(this.BLUEPRINT_URI + "/update_associations");
    private UriTemplate BEGIN_MIGRATION = new UriTemplate(this.BLUEPRINT_URI + "/migrations");
    private UriTemplate UPDATE_COURSE = new UriTemplate(this.BASE_URI);
    private UriTemplate SUBSCRIPTIONS = new UriTemplate(this.BLUEPRINT_SUBSCRIPTIONS_URI + "/migrations");
    private UriTemplate ALL_COURSE_SUBSCRIPTIONS = new UriTemplate(this.BLUEPRINT_SUBSCRIPTIONS_BASE_URI);

    public BlueprintTemplate getTemplate(String courseId, String templateId) {
        URI uri = this.GET_BY_COURSE_AND_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId, templateId});
        log.debug("uri: {}", (Object)uri);
        ResponseEntity template = this.restTemplate.getForEntity(uri, BlueprintTemplate.class);
        log.debug("Template: {}", (Object)template);
        return (BlueprintTemplate)template.getBody();
    }

    public List<BlueprintAssociatedCourse> getAssociatedCourses(String courseId, String templateId) {
        URI uri = this.GET_COURSES.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId, templateId});
        log.debug("uri: {}", (Object)uri);
        return this.doGet(uri, BlueprintAssociatedCourse[].class);
    }

    public BlueprintUpdateStatus updateAssociatedCourses(String courseId, String templateId, List<String> courseAdds, List<String> courseRemoves) {
        URI uri = this.UPDATE_BP_COURSES.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId, templateId});
        log.debug("uri: {}", (Object)uri);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        courseAdds.forEach(s -> builder.queryParam("course_ids_to_add[]", new Object[]{s}));
        courseRemoves.forEach(s -> builder.queryParam("course_ids_to_remove[]", new Object[]{s}));
        BlueprintUpdateStatus status = null;
        try {
            ResponseEntity response = this.restTemplate.exchange(builder.build().toUri(), HttpMethod.PUT, null, BlueprintUpdateStatus.class);
            log.debug("{}", (Object)response);
            status = (BlueprintUpdateStatus)response.getBody();
        }
        catch (HttpStatusCodeException rce) {
            log.error("uh oh", (Throwable)rce);
            ObjectMapper mapper = new ObjectMapper();
            try {
                status = (BlueprintUpdateStatus)mapper.readValue(rce.getResponseBodyAsString(), BlueprintUpdateStatus.class);
            }
            catch (IOException e) {
                log.error("uh oh", (Throwable)e);
            }
        }
        return status;
    }

    public BlueprintCourseUpdateStatus saveBlueprintConfiguration(String courseId, BlueprintConfiguration blueprintConfiguration) {
        URI uri = this.UPDATE_COURSE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId});
        log.debug("uri: {}", (Object)uri);
        boolean hasObjectRestrictions = blueprintConfiguration.isHasObjectRestrictions();
        boolean enabled = blueprintConfiguration.isEnabled();
        Map<String, BlueprintRestriction> objectRestrictions = blueprintConfiguration.getObjectRestrictions();
        BlueprintRestriction restrictions = blueprintConfiguration.getRestrictions();
        Object blueprintRestriction = restrictions != null ? restrictions : (hasObjectRestrictions ? null : new BlueprintRestriction());
        if (hasObjectRestrictions && (objectRestrictions == null || objectRestrictions.isEmpty())) {
            objectRestrictions = Arrays.stream(blueprintConfiguration.getDefaultRestrictionTypes()).collect(Collectors.toMap(type -> type, type -> new BlueprintRestriction(), (a, b) -> b));
        }
        CourseBlueprintDetails cbd = new CourseBlueprintDetails(enabled, (BlueprintRestriction)blueprintRestriction, hasObjectRestrictions, objectRestrictions);
        BlueprintCourseWrapper course = new BlueprintCourseWrapper(cbd);
        HttpEntity requestEntity = new HttpEntity((Object)course);
        log.debug("Request: {}", (Object)requestEntity);
        BlueprintCourseUpdateStatus bcus = new BlueprintCourseUpdateStatus();
        try {
            ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.PUT, requestEntity, Course.class);
            log.debug("Response: {}", (Object)response);
            bcus.setCourse((Course)response.getBody());
        }
        catch (HttpStatusCodeException hsce) {
            log.error("uh oh", (Throwable)hsce);
            ObjectMapper mapper = new ObjectMapper();
            try {
                bcus = (BlueprintCourseUpdateStatus)mapper.readValue(hsce.getResponseBodyAsString(), BlueprintCourseUpdateStatus.class);
            }
            catch (IOException e) {
                log.error("uh oh", (Throwable)e);
            }
        }
        return bcus;
    }

    public BlueprintMigrationStatus performMigration(String courseId, String templateId, boolean copySettings, boolean sendNotifications, String asUser, boolean publishAfterSync) {
        URI uri = this.BEGIN_MIGRATION.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId, templateId});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("send_notification", new Object[]{sendNotifications});
        builder.queryParam("copy_settings", new Object[]{copySettings});
        if (publishAfterSync) {
            builder.queryParam("publish_after_initial_sync", new Object[]{publishAfterSync});
        }
        if (asUser != null) {
            builder.queryParam("as_user_id", new Object[]{asUser});
        }
        BlueprintMigrationStatus status = new BlueprintMigrationStatus();
        try {
            ResponseEntity response = this.restTemplate.postForEntity(builder.build().toUri(), null, BlueprintMigration.class);
            status.setBlueprintMigration((BlueprintMigration)response.getBody());
        }
        catch (HttpStatusCodeException rce) {
            log.error("uh oh", (Throwable)rce);
            ObjectMapper mapper = new ObjectMapper();
            try {
                status = (BlueprintMigrationStatus)mapper.readValue(rce.getResponseBodyAsString(), BlueprintMigrationStatus.class);
                log.debug("status: {}", (Object)status);
                log.error("Unable to begin a migration: " + status.getMessage(), (Throwable)rce);
            }
            catch (IOException e) {
                log.error("uh oh", (Throwable)e);
            }
        }
        return status;
    }

    public List<BlueprintMigration> getMigrations(String courseId, String templateId) {
        URI uri = this.BEGIN_MIGRATION.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId, templateId});
        return this.doGet(uri, BlueprintMigration[].class);
    }

    public List<BlueprintMigration> getSubscriptions(String courseId, String subscriptionId) {
        URI uri = this.SUBSCRIPTIONS.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId, subscriptionId});
        return this.doGet(uri, BlueprintMigration[].class);
    }

    public List<BlueprintSubscription> getSubscriptions(String courseId) {
        URI uri = this.ALL_COURSE_SUBSCRIPTIONS.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId});
        return this.doGet(uri, BlueprintSubscription[].class);
    }

    public static class BlueprintConfiguration {
        boolean enabled;
        BlueprintRestriction restrictions;
        boolean hasObjectRestrictions;
        Map<String, BlueprintRestriction> objectRestrictions;
        String[] defaultRestrictionTypes;

        public boolean isEnabled() {
            return this.enabled;
        }

        public BlueprintRestriction getRestrictions() {
            return this.restrictions;
        }

        public boolean isHasObjectRestrictions() {
            return this.hasObjectRestrictions;
        }

        public Map<String, BlueprintRestriction> getObjectRestrictions() {
            return this.objectRestrictions;
        }

        public String[] getDefaultRestrictionTypes() {
            return this.defaultRestrictionTypes;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setRestrictions(BlueprintRestriction restrictions) {
            this.restrictions = restrictions;
        }

        public void setHasObjectRestrictions(boolean hasObjectRestrictions) {
            this.hasObjectRestrictions = hasObjectRestrictions;
        }

        public void setObjectRestrictions(Map<String, BlueprintRestriction> objectRestrictions) {
            this.objectRestrictions = objectRestrictions;
        }

        public void setDefaultRestrictionTypes(String[] defaultRestrictionTypes) {
            this.defaultRestrictionTypes = defaultRestrictionTypes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BlueprintConfiguration)) {
                return false;
            }
            BlueprintConfiguration other = (BlueprintConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            if (this.isHasObjectRestrictions() != other.isHasObjectRestrictions()) {
                return false;
            }
            BlueprintRestriction this$restrictions = this.getRestrictions();
            BlueprintRestriction other$restrictions = other.getRestrictions();
            if (this$restrictions == null ? other$restrictions != null : !((Object)this$restrictions).equals(other$restrictions)) {
                return false;
            }
            Map<String, BlueprintRestriction> this$objectRestrictions = this.getObjectRestrictions();
            Map<String, BlueprintRestriction> other$objectRestrictions = other.getObjectRestrictions();
            if (this$objectRestrictions == null ? other$objectRestrictions != null : !((Object)this$objectRestrictions).equals(other$objectRestrictions)) {
                return false;
            }
            return Arrays.deepEquals(this.getDefaultRestrictionTypes(), other.getDefaultRestrictionTypes());
        }

        protected boolean canEqual(Object other) {
            return other instanceof BlueprintConfiguration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            result = result * 59 + (this.isHasObjectRestrictions() ? 79 : 97);
            BlueprintRestriction $restrictions = this.getRestrictions();
            result = result * 59 + ($restrictions == null ? 43 : ((Object)$restrictions).hashCode());
            Map<String, BlueprintRestriction> $objectRestrictions = this.getObjectRestrictions();
            result = result * 59 + ($objectRestrictions == null ? 43 : ((Object)$objectRestrictions).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getDefaultRestrictionTypes());
            return result;
        }

        public String toString() {
            return "BlueprintService.BlueprintConfiguration(enabled=" + this.isEnabled() + ", restrictions=" + this.getRestrictions() + ", hasObjectRestrictions=" + this.isHasObjectRestrictions() + ", objectRestrictions=" + this.getObjectRestrictions() + ", defaultRestrictionTypes=" + Arrays.deepToString(this.getDefaultRestrictionTypes()) + ")";
        }

        public BlueprintConfiguration(boolean enabled, BlueprintRestriction restrictions, boolean hasObjectRestrictions, Map<String, BlueprintRestriction> objectRestrictions, String[] defaultRestrictionTypes) {
            this.enabled = enabled;
            this.restrictions = restrictions;
            this.hasObjectRestrictions = hasObjectRestrictions;
            this.objectRestrictions = objectRestrictions;
            this.defaultRestrictionTypes = defaultRestrictionTypes;
        }

        public BlueprintConfiguration() {
        }
    }

    private class CourseBlueprintDetails {
        private boolean blueprint;
        private BlueprintRestriction blueprint_restrictions;
        private boolean use_blueprint_restrictions_by_object_type;
        private Map<String, BlueprintRestriction> blueprint_restrictions_by_object_type;

        public boolean isBlueprint() {
            return this.blueprint;
        }

        public BlueprintRestriction getBlueprint_restrictions() {
            return this.blueprint_restrictions;
        }

        public boolean isUse_blueprint_restrictions_by_object_type() {
            return this.use_blueprint_restrictions_by_object_type;
        }

        public Map<String, BlueprintRestriction> getBlueprint_restrictions_by_object_type() {
            return this.blueprint_restrictions_by_object_type;
        }

        public void setBlueprint(boolean blueprint) {
            this.blueprint = blueprint;
        }

        public void setBlueprint_restrictions(BlueprintRestriction blueprint_restrictions) {
            this.blueprint_restrictions = blueprint_restrictions;
        }

        public void setUse_blueprint_restrictions_by_object_type(boolean use_blueprint_restrictions_by_object_type) {
            this.use_blueprint_restrictions_by_object_type = use_blueprint_restrictions_by_object_type;
        }

        public void setBlueprint_restrictions_by_object_type(Map<String, BlueprintRestriction> blueprint_restrictions_by_object_type) {
            this.blueprint_restrictions_by_object_type = blueprint_restrictions_by_object_type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CourseBlueprintDetails)) {
                return false;
            }
            CourseBlueprintDetails other = (CourseBlueprintDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isBlueprint() != other.isBlueprint()) {
                return false;
            }
            if (this.isUse_blueprint_restrictions_by_object_type() != other.isUse_blueprint_restrictions_by_object_type()) {
                return false;
            }
            BlueprintRestriction this$blueprint_restrictions = this.getBlueprint_restrictions();
            BlueprintRestriction other$blueprint_restrictions = other.getBlueprint_restrictions();
            if (this$blueprint_restrictions == null ? other$blueprint_restrictions != null : !((Object)this$blueprint_restrictions).equals(other$blueprint_restrictions)) {
                return false;
            }
            Map<String, BlueprintRestriction> this$blueprint_restrictions_by_object_type = this.getBlueprint_restrictions_by_object_type();
            Map<String, BlueprintRestriction> other$blueprint_restrictions_by_object_type = other.getBlueprint_restrictions_by_object_type();
            return !(this$blueprint_restrictions_by_object_type == null ? other$blueprint_restrictions_by_object_type != null : !((Object)this$blueprint_restrictions_by_object_type).equals(other$blueprint_restrictions_by_object_type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CourseBlueprintDetails;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isBlueprint() ? 79 : 97);
            result = result * 59 + (this.isUse_blueprint_restrictions_by_object_type() ? 79 : 97);
            BlueprintRestriction $blueprint_restrictions = this.getBlueprint_restrictions();
            result = result * 59 + ($blueprint_restrictions == null ? 43 : ((Object)$blueprint_restrictions).hashCode());
            Map<String, BlueprintRestriction> $blueprint_restrictions_by_object_type = this.getBlueprint_restrictions_by_object_type();
            result = result * 59 + ($blueprint_restrictions_by_object_type == null ? 43 : ((Object)$blueprint_restrictions_by_object_type).hashCode());
            return result;
        }

        public String toString() {
            return "BlueprintService.CourseBlueprintDetails(blueprint=" + this.isBlueprint() + ", blueprint_restrictions=" + this.getBlueprint_restrictions() + ", use_blueprint_restrictions_by_object_type=" + this.isUse_blueprint_restrictions_by_object_type() + ", blueprint_restrictions_by_object_type=" + this.getBlueprint_restrictions_by_object_type() + ")";
        }

        public CourseBlueprintDetails(boolean blueprint, BlueprintRestriction blueprint_restrictions, boolean use_blueprint_restrictions_by_object_type, Map<String, BlueprintRestriction> blueprint_restrictions_by_object_type) {
            this.blueprint = blueprint;
            this.blueprint_restrictions = blueprint_restrictions;
            this.use_blueprint_restrictions_by_object_type = use_blueprint_restrictions_by_object_type;
            this.blueprint_restrictions_by_object_type = blueprint_restrictions_by_object_type;
        }
    }

    private class BlueprintCourseWrapper {
        private CourseBlueprintDetails course;

        public CourseBlueprintDetails getCourse() {
            return this.course;
        }

        public void setCourse(CourseBlueprintDetails course) {
            this.course = course;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BlueprintCourseWrapper)) {
                return false;
            }
            BlueprintCourseWrapper other = (BlueprintCourseWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CourseBlueprintDetails this$course = this.getCourse();
            CourseBlueprintDetails other$course = other.getCourse();
            return !(this$course == null ? other$course != null : !((Object)this$course).equals(other$course));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BlueprintCourseWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CourseBlueprintDetails $course = this.getCourse();
            result = result * 59 + ($course == null ? 43 : ((Object)$course).hashCode());
            return result;
        }

        public String toString() {
            return "BlueprintService.BlueprintCourseWrapper(course=" + this.getCourse() + ")";
        }

        public BlueprintCourseWrapper(CourseBlueprintDetails course) {
            this.course = course;
        }
    }
}

