/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.canvas.services;

import edu.iu.uits.lms.canvas.model.catalog.CatalogEnrollment;
import edu.iu.uits.lms.canvas.model.catalog.EnrollmentGetWrapper;
import edu.iu.uits.lms.canvas.model.catalog.EnrollmentPostWrapper;
import edu.iu.uits.lms.canvas.services.CatalogSpringBaseService;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.util.UriTemplate;

@Service
public class CatalogListingService
extends CatalogSpringBaseService {
    private static final Logger log = LoggerFactory.getLogger(CatalogListingService.class);
    private static final String CATALOG_LISTING_URI = "{url}/enrollments/";
    private static final UriTemplate CATALOG_LISTING_TEMPLATE = new UriTemplate("{url}/enrollments/");

    public String getEnrollments(String listingId) {
        URI uri = CATALOG_LISTING_TEMPLATE.expand(new Object[]{this.catalogConfiguration.getBaseApiUrl()});
        log.debug(uri.toString());
        EnrollmentGetWrapper enrollmentGetWrapper = new EnrollmentGetWrapper(listingId);
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity enrollmentWrapperHttpEntity = new HttpEntity((Object)enrollmentGetWrapper, (MultiValueMap)headers);
            ResponseEntity getEnrollmentsResponse = this.restTemplate.exchange(uri, HttpMethod.GET, enrollmentWrapperHttpEntity, String.class);
            log.debug(getEnrollmentsResponse.toString());
            return (String)getEnrollmentsResponse.getBody();
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error getting catalog enrollments", (Throwable)hcee);
            return null;
        }
    }

    public boolean addUserToListing(String canvasUserId, String listingId) {
        URI uri = CATALOG_LISTING_TEMPLATE.expand(new Object[]{this.catalogConfiguration.getBaseApiUrl()});
        log.debug(uri.toString());
        EnrollmentPostWrapper enrollmentPostWrapper = new EnrollmentPostWrapper(new CatalogEnrollment(canvasUserId, listingId));
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity enrollmentWrapperHttpEntity = new HttpEntity((Object)enrollmentPostWrapper, (MultiValueMap)headers);
            ResponseEntity createEnrollmentResponse = this.restTemplate.exchange(uri, HttpMethod.POST, enrollmentWrapperHttpEntity, String.class);
            log.debug(createEnrollmentResponse.toString());
            HttpStatus responseStatus = createEnrollmentResponse.getStatusCode();
            if (HttpStatus.CREATED.equals((Object)responseStatus)) {
                return true;
            }
            log.error("Error creating enrollment term. Request to Canvas was not successful. Response code: " + responseStatus + ", reason: " + responseStatus.getReasonPhrase() + ", entity: " + (HttpEntity)createEnrollmentResponse);
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error adding user to listing", (Throwable)hcee);
        }
        return false;
    }
}

