/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.canvas.services;

import edu.iu.uits.lms.canvas.model.CommunicationChannel;
import edu.iu.uits.lms.canvas.model.CommunicationChannelCreateWrapper;
import edu.iu.uits.lms.canvas.services.CanvasUserNotFoundException;
import edu.iu.uits.lms.canvas.services.SpringBaseService;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.util.UriTemplate;

@Service
public class CommunicationChannelService
extends SpringBaseService {
    private static final Logger log = LoggerFactory.getLogger(CommunicationChannelService.class);
    private static final String CC_BASE_URI = "{url}/users/{user_id}/communication_channels";
    private static final UriTemplate CC_BASE_TEMPLATE = new UriTemplate("{url}/users/{user_id}/communication_channels");
    private static final String CC_URI = "{url}/users/{user_id}/communication_channels/{id}";
    private static final UriTemplate CC_TEMPLATE = new UriTemplate("{url}/users/{user_id}/communication_channels/{id}");

    public List<CommunicationChannel> getCommunicationChannels(String canvasUserId, String type) throws CanvasUserNotFoundException {
        ArrayList<CommunicationChannel> typedChannels = new ArrayList<CommunicationChannel>();
        List<CommunicationChannel> allChannels = this.getCommunicationChannels(canvasUserId);
        for (CommunicationChannel communicationChannel : allChannels) {
            if (!type.equals(communicationChannel.getType())) continue;
            typedChannels.add(communicationChannel);
        }
        return typedChannels;
    }

    public List<CommunicationChannel> getCommunicationChannels(String canvasUserId) throws CanvasUserNotFoundException {
        URI uri = CC_BASE_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), canvasUserId});
        log.debug("{}", (Object)uri);
        return this.doGet(uri, CommunicationChannel[].class);
    }

    public CommunicationChannel getPrimaryEmailChannel(String canvasUserId) throws CanvasUserNotFoundException {
        List<CommunicationChannel> communicationChannels = this.getCommunicationChannels(canvasUserId);
        CommunicationChannel communicationChannel = null;
        int currentChannelPosition = 999;
        if (communicationChannels != null) {
            for (CommunicationChannel channel : communicationChannels) {
                if (!"email".equals(channel.getType()) || channel.getPosition() >= currentChannelPosition) continue;
                communicationChannel = channel;
                currentChannelPosition = channel.getPosition();
            }
        }
        return communicationChannel;
    }

    public CommunicationChannel getChannelByEmail(String canvasUserId, String email) throws CanvasUserNotFoundException {
        List<CommunicationChannel> communicationChannels = this.getCommunicationChannels(canvasUserId);
        CommunicationChannel communicationChannel = null;
        if (communicationChannels != null) {
            communicationChannel = this.getChannelByEmail(email, communicationChannels);
        }
        return communicationChannel;
    }

    public CommunicationChannel getChannelByEmail(String email, List<CommunicationChannel> channels) {
        CommunicationChannel communicationChannel = null;
        for (CommunicationChannel channel : channels) {
            if (!"email".equals(channel.getType()) || !channel.getAddress().equals(email)) continue;
            communicationChannel = channel;
            break;
        }
        return communicationChannel;
    }

    public void deleteCommunicationChannel(String channelId, String canvasUserId) {
        URI uri = CC_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), canvasUserId, channelId});
        log.debug("{}", (Object)uri);
        try {
            this.restTemplate.delete(uri);
        }
        catch (HttpClientErrorException hcee) {
            throw new RuntimeException("Failed to delete communication_channel '" + channelId + "' for user '" + canvasUserId + "'", hcee);
        }
    }

    public CommunicationChannel createCommunicationChannel(String canvasUserId, CommunicationChannelCreateWrapper communicationChannel) {
        URI uri = CC_BASE_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), canvasUserId});
        log.debug("{}", (Object)uri);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity requestEntity = new HttpEntity((Object)communicationChannel, (MultiValueMap)headers);
        try {
            return (CommunicationChannel)this.restTemplate.postForObject(uri, (Object)requestEntity, CommunicationChannel.class);
        }
        catch (HttpClientErrorException hcee) {
            log.error("Failed to create communication channel for user " + canvasUserId, (Throwable)hcee);
            return null;
        }
    }

    public CommunicationChannelCreateWrapper buildCommunicationChannelWrapper(String canvasUserId, String email, String type) {
        CommunicationChannel newChannel = new CommunicationChannel();
        newChannel.setUserId(canvasUserId);
        newChannel.setAddress(email);
        newChannel.setType(type);
        CommunicationChannelCreateWrapper channelWrapper = new CommunicationChannelCreateWrapper();
        channelWrapper.setSkipConfirmation(true);
        channelWrapper.setCommunicationChannel(newChannel);
        return channelWrapper;
    }
}

