/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.canvas.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.iu.uits.lms.canvas.model.ContentMigration;
import edu.iu.uits.lms.canvas.model.ContentMigrationCreateWrapper;
import edu.iu.uits.lms.canvas.services.SpringBaseService;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

@Service
public class ContentMigrationService
extends SpringBaseService {
    private static final Logger log = LoggerFactory.getLogger(ContentMigrationService.class);
    private static final String BASE_URI = "{url}/courses/{course_id}/content_migrations";
    private static final UriTemplate CREATE_COURSE_MIGRATION = new UriTemplate("{url}/courses/{course_id}/content_migrations");
    private static final UriTemplate GET_MIGRATION_STATUS_BY_COURSE = new UriTemplate("{url}/courses/{course_id}/content_migrations");
    private static final UriTemplate GET_MIGRATION_STATUS_BY_ID = new UriTemplate("{url}/courses/{course_id}/content_migrations/{migrationId}");

    @Deprecated(since="5.0.8")
    public ContentMigration importCCIntoCourse(String courseId, String idFieldName, String fileUrl) {
        String altCourseId = this.buildAlternateId(courseId, idFieldName);
        URI uri = CREATE_COURSE_MIGRATION.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), altCourseId});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("settings[file_url]", new Object[]{fileUrl});
        builder.queryParam("migration_type", new Object[]{"common_cartridge_importer"});
        log.debug("woooooo: " + builder.build().toUri());
        ContentMigration contentMigration = null;
        try {
            ResponseEntity response = this.restTemplate.postForEntity(builder.build().toUri(), null, ContentMigration.class);
            contentMigration = (ContentMigration)response.getBody();
        }
        catch (HttpStatusCodeException rce) {
            log.error("Error performing content migration for course: " + courseId, (Throwable)rce);
            ObjectMapper mapper = new ObjectMapper();
            try {
                String status = (String)mapper.readValue(rce.getResponseBodyAsString(), String.class);
                log.error("Unable to begin a migration: " + status);
            }
            catch (IOException e) {
                log.error("Error parsing error message", (Throwable)e);
            }
        }
        return contentMigration;
    }

    public ContentMigration initiateContentMigration(String courseId, String idFieldName, ContentMigrationCreateWrapper wrapper) {
        String altCourseId = this.buildAlternateId(courseId, idFieldName);
        URI uri = CREATE_COURSE_MIGRATION.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), altCourseId});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        log.debug("woooooo: " + builder.build().toUri());
        ContentMigration contentMigration = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((Object)wrapper, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.postForEntity(builder.build().toUri(), (Object)requestEntity, ContentMigration.class);
            contentMigration = (ContentMigration)response.getBody();
        }
        catch (HttpStatusCodeException rce) {
            log.error("Error performing content migration for course: " + courseId, (Throwable)rce);
            ObjectMapper mapper = new ObjectMapper();
            try {
                String status = (String)mapper.readValue(rce.getResponseBodyAsString(), String.class);
                log.error("Unable to begin a migration: " + status);
            }
            catch (IOException e) {
                log.error("Error parsing error message", (Throwable)e);
            }
        }
        catch (Exception e) {
            log.error("Error performing content migration for course: " + courseId, (Throwable)e);
        }
        return contentMigration;
    }

    public List<ContentMigration> getMigrationStatuses(String courseId, String idFieldName) {
        String altCourseId = this.buildAlternateId(courseId, idFieldName);
        URI uri = GET_MIGRATION_STATUS_BY_COURSE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), altCourseId});
        log.debug("uri {}", (Object)uri);
        return this.doGet(uri, ContentMigration[].class);
    }

    public ContentMigration getMigrationStatus(String courseId, String idFieldName, String migrationId) {
        String altCourseId = this.buildAlternateId(courseId, idFieldName);
        URI uri = GET_MIGRATION_STATUS_BY_ID.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), altCourseId, migrationId});
        log.debug("uri {}", (Object)uri);
        ResponseEntity template = this.restTemplate.getForEntity(uri, ContentMigration.class);
        log.debug("template {}", (Object)template);
        return (ContentMigration)template.getBody();
    }
}

