/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.canvas.services;

import edu.iu.uits.lms.canvas.model.Conversation;
import edu.iu.uits.lms.canvas.model.ConversationCreateWrapper;
import edu.iu.uits.lms.canvas.services.SpringBaseService;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

@Service
public class ConversationService
extends SpringBaseService {
    private static final Logger log = LoggerFactory.getLogger(ConversationService.class);
    private static final String BASE_URI = "{url}/conversations";
    private static final String DELETE_URI = "{url}/conversations/{id}";
    private static final String GET_URI = "{url}/conversations/{id}";
    private static final UriTemplate BASE_TEMPLATE = new UriTemplate("{url}/conversations");
    private static final UriTemplate DELETE_TEMPLATE = new UriTemplate("{url}/conversations/{id}");
    private static final UriTemplate GET_TEMPLATE = new UriTemplate("{url}/conversations/{id}");

    public Conversation postConversation(ConversationCreateWrapper conversationCreateWrapper, String asUser, boolean isBulk) {
        URI uri = BASE_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl()});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"subject", (Object)conversationCreateWrapper.getSubject());
        map.add((Object)"body", (Object)conversationCreateWrapper.getBody());
        if (isBulk) {
            conversationCreateWrapper.setGroupConversation(true);
            conversationCreateWrapper.setMode("async");
            map.add((Object)"bulk_message", (Object)String.valueOf(true));
        } else {
            map.add((Object)"force_new", (Object)String.valueOf(true));
        }
        map.add((Object)"group_conversation", (Object)String.valueOf(conversationCreateWrapper.isGroupConversation()));
        if (conversationCreateWrapper.isGroupConversation()) {
            map.add((Object)"context_code", (Object)conversationCreateWrapper.getContextCode());
        }
        if (conversationCreateWrapper.getMode() != null) {
            map.add((Object)"mode", (Object)conversationCreateWrapper.getMode());
        }
        if (asUser != null) {
            map.add((Object)"as_user_id", (Object)asUser);
        }
        HttpEntity requestEntity = new HttpEntity((Object)map, (MultiValueMap)headers);
        if (conversationCreateWrapper.getAttachmentIds() != null) {
            for (String attachmentId : conversationCreateWrapper.getAttachmentIds()) {
                builder.queryParam("attachment_ids[]", new Object[]{attachmentId});
            }
        }
        for (String recipient : conversationCreateWrapper.getRecipients()) {
            builder.queryParam("recipients[]", new Object[]{recipient});
        }
        try {
            ResponseEntity conversationsEntity = this.restTemplate.postForEntity(builder.build().toUri(), (Object)requestEntity, Conversation[].class);
            if (conversationsEntity != null && conversationsEntity.getBody() != null && ((Conversation[])conversationsEntity.getBody()).length > 0) {
                return ((Conversation[])conversationsEntity.getBody())[0];
            }
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error posting conversation", (Throwable)hcee);
        }
        return null;
    }

    public Conversation deleteConversation(String id, String asUser) {
        URI uri = DELETE_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), id});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        if (asUser != null) {
            builder.queryParam("as_user_id", new Object[]{asUser});
        }
        ResponseEntity response = this.restTemplate.exchange(builder.build().toUri(), HttpMethod.DELETE, null, Conversation.class);
        return (Conversation)response.getBody();
    }

    public Conversation getConversation(String id, String asUser) {
        URI uri = GET_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), id});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        if (asUser != null) {
            builder.queryParam("as_user_id", new Object[]{asUser});
        }
        ResponseEntity response = this.restTemplate.exchange(builder.build().toUri(), HttpMethod.GET, null, Conversation.class);
        return (Conversation)response.getBody();
    }
}

