/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.canvas.services;

import edu.iu.uits.lms.canvas.model.Course;
import edu.iu.uits.lms.canvas.model.CourseCreateWrapper;
import edu.iu.uits.lms.canvas.model.CourseSectionUpdateWrapper;
import edu.iu.uits.lms.canvas.model.Enrollment;
import edu.iu.uits.lms.canvas.model.EnrollmentCreateWrapper;
import edu.iu.uits.lms.canvas.model.ExternalTool;
import edu.iu.uits.lms.canvas.model.Favorite;
import edu.iu.uits.lms.canvas.model.FeatureFlag;
import edu.iu.uits.lms.canvas.model.QuotaInfo;
import edu.iu.uits.lms.canvas.model.Section;
import edu.iu.uits.lms.canvas.model.SectionCreateWrapper;
import edu.iu.uits.lms.canvas.model.User;
import edu.iu.uits.lms.canvas.services.SpringBaseService;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

@Service
public class CourseService
extends SpringBaseService {
    private static final Logger log = LoggerFactory.getLogger(CourseService.class);
    private static final String ACCOUNTS_BASE_URI = "{url}/accounts/{id}";
    private static final String ACCOUNTS_COURSES_URI = "{url}/accounts/{id}/courses";
    private static final String COURSES_BASE_URI = "{url}/courses";
    private static final String FAVORITES_URI = "{url}/users/self/favorites/courses";
    private static final String COURSE_URI = "{url}/courses/{id}";
    private static final String COURSE_USERS_URI = "{url}/courses/{id}/users";
    private static final String COURSE_ENROLLMENTS_URI = "{url}/courses/{id}/enrollments";
    private static final String COURSE_DELETE_ENROLLMENTS_URI = "{url}/courses/{id}/enrollments/{enrollmentId}";
    private static final String USERS_URI = "{url}/users/{id}";
    private static final String COURSE_SECTIONS_BASE_URI = "{url}/courses/{id}/sections";
    private static final String SECTIONS_BASE_URI = "{url}/sections";
    private static final String SECTION_ENROLLMENTS_URI = "{url}/sections/{id}/enrollments";
    private UriTemplate ACCOUNTS_COURSES_TEMPLATE = new UriTemplate("{url}/accounts/{id}/courses");
    private UriTemplate COURSE_BASE_TEMPLATE = new UriTemplate("{url}/courses");
    private UriTemplate COURSE_ENROLLMENTS_TEMPLATE = new UriTemplate("{url}/courses/{id}/enrollments");
    private UriTemplate COURSE_DELETE_ENROLLMENTS_TEMPLATE = new UriTemplate("{url}/courses/{id}/enrollments/{enrollmentId}");
    private UriTemplate COURSE_TEMPLATE = new UriTemplate("{url}/courses/{id}");
    private UriTemplate FAVORITES_TEMPLATE = new UriTemplate("{url}/users/self/favorites/courses/{id}");
    private UriTemplate COURSE_USERS_TEMPLATE = new UriTemplate("{url}/courses/{id}/users");
    private UriTemplate USERS_TEMPLATE = new UriTemplate("{url}/users/{id}");
    private UriTemplate COURSE_SECTIONS_TEMPLATE = new UriTemplate("{url}/courses/{id}/sections");
    private UriTemplate SECTION_ENROLLMENTS_TEMPLATE = new UriTemplate("{url}/sections/{id}/enrollments");

    public Course getCourse(String courseId) {
        URI uri = this.COURSE_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("include[]", new Object[]{"term"});
        try {
            ResponseEntity courseResponseEntity = this.restTemplate.getForEntity(builder.build().toUri(), Course.class);
            if (courseResponseEntity != null) {
                return (Course)courseResponseEntity.getBody();
            }
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error: ", (Throwable)hcee);
        }
        return null;
    }

    public List<User> getInstructorsForCourse(String courseId) {
        URI uri = this.COURSE_USERS_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("enrollment_type", new Object[]{"teacher"});
        return this.doGet(builder.build().toUri(), User[].class);
    }

    public List<Course> getCoursesTaughtBy(String IUNetworkId, boolean excludeBlueprint, boolean includeSections, boolean includeTerm) {
        List<String> workflowStates = Arrays.asList("available", "unpublished", "completed");
        return this.getCoursesForUserByEnrollmentType(IUNetworkId, "teacher", excludeBlueprint, includeSections, includeTerm, workflowStates);
    }

    public List<Course> getCoursesForUserByEnrollmentType(String iuNetworkId, String enrollmentType, boolean excludeBlueprint, boolean includeSections, boolean includeTerm, List<String> states) {
        String bonusPath = "sis_login_id:" + iuNetworkId + "/courses";
        URI uri = this.USERS_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), bonusPath});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("exclude_blueprint_courses", new Object[]{excludeBlueprint});
        if (includeSections) {
            builder.queryParam("include[]", new Object[]{"sections"});
        }
        if (includeTerm) {
            builder.queryParam("include[]", new Object[]{"term"});
        }
        if (states != null) {
            for (String state : states) {
                builder.queryParam("state[]", new Object[]{state});
            }
        }
        builder.queryParam("enrollment_type", new Object[]{enrollmentType});
        builder.queryParam("per_page", new Object[]{"100"});
        return this.doGet(builder.build().toUri(), Course[].class);
    }

    public List<Course> getCoursesForUser(String iuNetworkId, boolean includeSections, boolean includeTerm, boolean excludeBlueprint, List<String> states) {
        URI uri = this.COURSE_BASE_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl()});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("as_user_id", new Object[]{"sis_login_id:" + iuNetworkId});
        builder.queryParam("exclude_blueprint_courses", new Object[]{excludeBlueprint});
        builder.queryParam("include[]", new Object[]{"favorites"});
        if (includeSections) {
            builder.queryParam("include[]", new Object[]{"sections"});
        }
        if (includeTerm) {
            builder.queryParam("include[]", new Object[]{"term"});
        }
        if (states != null) {
            for (String state : states) {
                builder.queryParam("state[]", new Object[]{state});
            }
        }
        builder.queryParam("per_page", new Object[]{"100"});
        return this.doGet(builder.build().toUri(), Course[].class);
    }

    public List<Enrollment> getStudentCourseEnrollment(@NonNull String courseId) {
        if (courseId == null) {
            throw new NullPointerException("courseId is marked non-null but is null");
        }
        URI uri = this.COURSE_ENROLLMENTS_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("type[]", new Object[]{"StudentEnrollment"});
        builder.queryParam("per_page", new Object[]{"50"});
        builder.queryParam("state[]", new Object[]{"active"});
        return this.doGet(builder.build().toUri(), Enrollment[].class);
    }

    public List<Section> getCourseSections(@NonNull String courseId) {
        if (courseId == null) {
            throw new NullPointerException("courseId is marked non-null but is null");
        }
        URI uri = this.COURSE_SECTIONS_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId});
        return this.doGet(uri, Section[].class);
    }

    public QuotaInfo getCourseQuotaInfo(@NonNull String courseId) {
        if (courseId == null) {
            throw new NullPointerException("courseId is marked non-null but is null");
        }
        URI uri = this.COURSE_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.path("/files/quota");
        try {
            ResponseEntity courseQuotaInfoResponseEntity = this.restTemplate.getForEntity(builder.build().toUri(), QuotaInfo.class);
            log.debug("courseQuotaInfoResponseEntity: {}", (Object)courseQuotaInfoResponseEntity);
            if (courseQuotaInfoResponseEntity != null) {
                return (QuotaInfo)courseQuotaInfoResponseEntity.getBody();
            }
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error:", (Throwable)hcee);
        }
        return null;
    }

    public Favorite addCourseToFavorites(String asUserLogin, String courseId) {
        URI uri = this.FAVORITES_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("as_user_id", new Object[]{"sis_login_id:" + asUserLogin});
        try {
            ResponseEntity response = this.restTemplate.exchange(builder.build().toUri(), HttpMethod.POST, null, Favorite.class);
            log.debug("{}", (Object)response);
            if (response.getStatusCode() != HttpStatus.OK) {
                throw new RuntimeException("Request to Canvas was not successful. Response code: " + response.getStatusCode() + ", reason: " + response.getStatusCode().getReasonPhrase() + ", body: " + response.getBody());
            }
            return (Favorite)response.getBody();
        }
        catch (HttpClientErrorException hcee) {
            log.error("error adding course to favorites", (Throwable)hcee);
            throw new RuntimeException("Error adding course to favorites", hcee);
        }
    }

    public Favorite removeCourseAsFavorite(String asUserLogin, String courseId) {
        URI uri = this.FAVORITES_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("as_user_id", new Object[]{"sis_login_id:" + asUserLogin});
        try {
            ResponseEntity response = this.restTemplate.exchange(builder.build().toUri(), HttpMethod.DELETE, null, Favorite.class);
            log.debug("{}", (Object)response);
            if (response.getStatusCode() != HttpStatus.OK) {
                throw new RuntimeException("Request to Canvas was not successful. Response code: " + response.getStatusCode() + ", reason: " + response.getStatusCode().getReasonPhrase() + ", body: " + response.getBody());
            }
            return (Favorite)response.getBody();
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error removing course from favorites", (Throwable)hcee);
            throw new RuntimeException("Error removing course from favorites", hcee);
        }
    }

    public List<User> getUsersForCourseByType(String courseId, List<String> enrollmentTypes, List<String> enrollmentStates) {
        return this.getUsersForCourseByTypeOptionalEnrollments(courseId, enrollmentTypes, enrollmentStates, false);
    }

    public List<User> getUsersForCourseByTypeOptionalEnrollments(String courseId, List<String> enrollmentTypes, List<String> enrollmentStates, boolean includeEnrollments) {
        URI uri = this.COURSE_USERS_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        if (includeEnrollments) {
            builder.queryParam("include[]", new Object[]{"enrollments"});
        }
        if (enrollmentTypes != null) {
            for (String type : enrollmentTypes) {
                builder.queryParam("enrollment_type[]", new Object[]{type});
            }
        }
        if (enrollmentStates != null) {
            for (String enrollmentState : enrollmentStates) {
                builder.queryParam("enrollment_state[]", new Object[]{enrollmentState});
            }
        }
        return this.doGet(builder.build().toUri(), User[].class);
    }

    public void updateCourseGradingStandard(String id, String gradingStandardId) {
        if (id == null) {
            throw new IllegalArgumentException("Null id passed to updateCourseGradingStandard.");
        }
        URI uri = this.COURSE_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), id});
        log.debug("{}", (Object)uri);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("course[grading_standard_id]", new Object[]{gradingStandardId});
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            ResponseEntity updateCourseGradingStandardResponse = this.restTemplate.exchange(builder.build().toUri(), HttpMethod.PUT, null, String.class);
            log.debug("{}", (Object)updateCourseGradingStandardResponse);
            ResponseEntity responseEntity = updateCourseGradingStandardResponse;
            if (responseEntity.getStatusCode() != HttpStatus.OK) {
                throw new RuntimeException("Request to Canvas was not successful. Response code: " + responseEntity.getStatusCode() + ", reason: " + responseEntity.getStatusCode().getReasonPhrase() + ", body: " + (String)responseEntity.getBody());
            }
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error updating course grading standard", (Throwable)hcee);
        }
    }

    public Course updateCourseNameAndSisCourseId(String canvasCourseId, CourseSectionUpdateWrapper courseSectionUpdateWrapper) {
        if (canvasCourseId == null) {
            throw new IllegalArgumentException("Null id passed to updateCourseNameAndSisCourseId.");
        }
        URI uri = this.COURSE_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), canvasCourseId});
        log.debug("{}", (Object)uri);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        multiValueMap.add((Object)"course[name]", (Object)courseSectionUpdateWrapper.getName());
        multiValueMap.add((Object)"course[sis_course_id]", (Object)courseSectionUpdateWrapper.getSisId());
        multiValueMap.add((Object)"course[course_code]", (Object)courseSectionUpdateWrapper.getCourseCode());
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            HttpEntity requestEntity = new HttpEntity((Object)multiValueMap, (MultiValueMap)headers);
            ResponseEntity updateCourseNameAndSisCourseIdResponse = this.restTemplate.exchange(builder.build().toUri(), HttpMethod.PUT, requestEntity, Course.class);
            log.debug("{}", (Object)updateCourseNameAndSisCourseIdResponse);
            ResponseEntity responseEntity = updateCourseNameAndSisCourseIdResponse;
            if (responseEntity.getStatusCode() != HttpStatus.OK) {
                throw new RuntimeException("Request to Canvas was not successful. Response code: " + responseEntity.getStatusCode() + ", reason: " + responseEntity.getStatusCode().getReasonPhrase() + ", body: " + responseEntity.getBody());
            }
            return (Course)updateCourseNameAndSisCourseIdResponse.getBody();
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error updating course name and sis_course_id", (Throwable)hcee);
            return null;
        }
    }

    public void updateCourseEndDate(String id, String idFieldName, @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime courseStartDate, @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime courseEndDate, boolean restrictEnrollmentsToCourseDates) {
        if (id == null) {
            throw new IllegalArgumentException("Null id passed to updateCourseEndDate.");
        }
        this.updateTermAndCourseEndDate(id, idFieldName, null, courseStartDate, courseEndDate, restrictEnrollmentsToCourseDates);
    }

    public Course updateTermAndCourseEndDate(String id, String idFieldName, String termId, @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime courseStartDate, @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime courseEndDate, boolean restrictEnrollmentsToCourseDates) {
        if (id == null) {
            throw new IllegalArgumentException("Null id passed to updateTermAndCourseEndDate.");
        }
        id = this.buildAlternateId(id, idFieldName);
        URI uri = this.COURSE_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), id});
        log.debug(uri.toString());
        String courseEndDateStr = "";
        if (courseEndDate != null) {
            courseEndDateStr = courseEndDate.toString();
        }
        String courseStartDateStr = "";
        if (courseStartDate != null) {
            courseStartDateStr = courseStartDate.toString();
        }
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("course[start_at]", new Object[]{courseStartDateStr});
        builder.queryParam("course[end_at]", new Object[]{courseEndDateStr});
        builder.queryParam("course[restrict_enrollments_to_course_dates]", new Object[]{restrictEnrollmentsToCourseDates});
        if (termId != null && !termId.isEmpty()) {
            builder.queryParam("course[term_id]", new Object[]{termId});
        }
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            ResponseEntity updateTermAndCourseEndDateResponse = this.restTemplate.exchange(builder.build().toUri(), HttpMethod.PUT, null, Course.class);
            log.debug(updateTermAndCourseEndDateResponse.toString());
            ResponseEntity responseEntity = updateTermAndCourseEndDateResponse;
            if (responseEntity.getStatusCode() != HttpStatus.OK) {
                throw new RuntimeException("Request to Canvas was not successful. Response code: " + responseEntity.getStatusCode() + ", reason: " + responseEntity.getStatusCode().getReasonPhrase() + ", body: " + responseEntity.getBody());
            }
            return (Course)updateTermAndCourseEndDateResponse.getBody();
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error updating term and course end dates", (Throwable)hcee);
            return null;
        }
    }

    public void updateCourseFrontPage(String id, String defaultViewType) {
        if (id == null) {
            throw new IllegalArgumentException("Null id passed to updateCourseFrontPage.");
        }
        URI uri = this.COURSE_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), id});
        log.debug("{}", (Object)uri);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("course[default_view]", new Object[]{defaultViewType});
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            ResponseEntity updateCourseFrontPageResponse = this.restTemplate.exchange(builder.build().toUri(), HttpMethod.PUT, null, String.class);
            log.debug("{}", (Object)updateCourseFrontPageResponse);
            ResponseEntity responseEntity = updateCourseFrontPageResponse;
            if (responseEntity.getStatusCode() != HttpStatus.OK) {
                throw new RuntimeException("Request to Canvas was not successful. Response code: " + responseEntity.getStatusCode() + ", reason: " + responseEntity.getStatusCode().getReasonPhrase() + ", body: " + (String)responseEntity.getBody());
            }
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error updating course front page", (Throwable)hcee);
        }
    }

    public Course createCourse(CourseCreateWrapper newCourse) {
        Course savedCourse = null;
        String accountId = newCourse.getAccountId() == null || newCourse.getAccountId().isEmpty() ? this.canvasConfiguration.getAccountId() : newCourse.getAccountId();
        URI uri = this.ACCOUNTS_COURSES_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), accountId});
        log.debug("{}", (Object)uri);
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity createNewCourseRequest = new HttpEntity((Object)newCourse, (MultiValueMap)headers);
            ResponseEntity createNewCourseResponse = this.restTemplate.exchange(uri, HttpMethod.POST, createNewCourseRequest, Course.class);
            log.debug("{}", (Object)createNewCourseResponse);
            savedCourse = (Course)createNewCourseResponse.getBody();
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error creating course", (Throwable)hcee);
            throw new RuntimeException("Error creating course", hcee);
        }
        return savedCourse;
    }

    public Section createCourseSection(SectionCreateWrapper newSection) {
        URI uri = this.COURSE_SECTIONS_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), newSection.getCourseSection().getCourse_id()});
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity sectionCreateWrapperRequestEntity = new HttpEntity((Object)newSection, (MultiValueMap)headers);
            ResponseEntity sectionCreateWrapperResponseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, sectionCreateWrapperRequestEntity, Section.class);
            log.debug("{}", (Object)sectionCreateWrapperResponseEntity);
            if (sectionCreateWrapperResponseEntity != null) {
                Section savedSection = (Section)sectionCreateWrapperResponseEntity.getBody();
                return savedSection;
            }
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error creating course section", (Throwable)hcee);
        }
        return null;
    }

    public Enrollment createEnrollment(EnrollmentCreateWrapper enrollmentWrapper) {
        Enrollment savedEnrollment = null;
        String sectionId = enrollmentWrapper.getEnrollment().getCourseSectionId();
        URI uri = this.SECTION_ENROLLMENTS_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), sectionId});
        log.debug("{}", (Object)uri);
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity createNewCourseSectionEnrollmentRequest = new HttpEntity((Object)enrollmentWrapper, (MultiValueMap)headers);
            ResponseEntity createNewCourseSectionEnrollmentResponse = this.restTemplate.exchange(uri, HttpMethod.POST, createNewCourseSectionEnrollmentRequest, Enrollment.class);
            log.debug("{}", (Object)createNewCourseSectionEnrollmentResponse);
            ResponseEntity responseEntity = createNewCourseSectionEnrollmentResponse;
            if (responseEntity.getStatusCode() != HttpStatus.OK) {
                throw new RuntimeException("Request to Canvas was not successful. Response code: " + responseEntity.getStatusCode() + ", reason: " + responseEntity.getStatusCode().getReasonPhrase() + ", body: " + responseEntity.getBody());
            }
            savedEnrollment = (Enrollment)createNewCourseSectionEnrollmentResponse.getBody();
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error creating enrollment", (Throwable)hcee);
            throw new RuntimeException("Error creating course section enrollment", hcee);
        }
        return savedEnrollment;
    }

    public FeatureFlag getCourseFeature(String courseId, String featureId) {
        URI uri = this.COURSE_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.path("/features");
        builder.path("/flags");
        builder.path("/" + featureId);
        try {
            ResponseEntity featureFlagResponseEntity = this.restTemplate.getForEntity(builder.build().toUri(), FeatureFlag.class);
            log.debug("{}", (Object)featureFlagResponseEntity);
            ResponseEntity responseEntity = featureFlagResponseEntity;
            if (responseEntity.getStatusCode() != HttpStatus.OK) {
                throw new RuntimeException("Request to Canvas was not successful. Response code: " + responseEntity.getStatusCode() + ", reason: " + responseEntity.getStatusCode().getReasonPhrase() + ", body: " + responseEntity.getBody());
            }
            if (featureFlagResponseEntity != null) {
                return (FeatureFlag)featureFlagResponseEntity.getBody();
            }
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error getting course features", (Throwable)hcee);
            throw new RuntimeException("Error getting course feature", hcee);
        }
        return null;
    }

    public FeatureFlag setCourseFeature(String courseId, String featureId, String state) {
        URI uri = this.COURSE_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.path("/features");
        builder.path("/flags");
        builder.path("/" + featureId);
        builder.queryParam("state", new Object[]{state});
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            ResponseEntity featureFlagResponse = this.restTemplate.exchange(builder.build().toUri(), HttpMethod.PUT, null, FeatureFlag.class);
            log.debug("{}", (Object)featureFlagResponse);
            ResponseEntity responseEntity = featureFlagResponse;
            if (responseEntity.getStatusCode() != HttpStatus.OK) {
                throw new RuntimeException("Request to Canvas was not successful. Response code: " + responseEntity.getStatusCode() + ", reason: " + responseEntity.getStatusCode().getReasonPhrase() + ", body: " + responseEntity.getBody());
            }
            if (featureFlagResponse != null) {
                return (FeatureFlag)featureFlagResponse.getBody();
            }
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error updating course feature", (Throwable)hcee);
            throw new RuntimeException("Error setting course feature", hcee);
        }
        return null;
    }

    public FeatureFlag removeCourseFeature(String courseId, String featureId) {
        URI uri = this.COURSE_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.path("/features");
        builder.path("/flags");
        builder.path("/" + featureId);
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            ResponseEntity featureFlagResponse = this.restTemplate.exchange(builder.build().toUri(), HttpMethod.DELETE, null, FeatureFlag.class);
            log.debug("{}", (Object)featureFlagResponse);
            ResponseEntity responseEntity = featureFlagResponse;
            if (responseEntity.getStatusCode() != HttpStatus.OK) {
                throw new RuntimeException("Request to Canvas was not successful. Response code: " + responseEntity.getStatusCode() + ", reason: " + responseEntity.getStatusCode().getReasonPhrase() + ", body: " + responseEntity.getBody());
            }
            if (featureFlagResponse != null) {
                return (FeatureFlag)featureFlagResponse.getBody();
            }
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error deleting course feature", (Throwable)hcee);
            throw new RuntimeException("Error setting course feature", hcee);
        }
        return null;
    }

    public List<User> getRosterForCourseAsUser(String courseId, String asUser, List<String> enrollmentStates) {
        URI uri = this.COURSE_USERS_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("include[]", new Object[]{"email"});
        builder.queryParam("include[]", new Object[]{"avatar_url"});
        builder.queryParam("include[]", new Object[]{"enrollments"});
        if (asUser != null) {
            builder.queryParam("as_user_id", new Object[]{asUser});
        }
        if (enrollmentStates != null) {
            for (String enrollmentState : enrollmentStates) {
                builder.queryParam("enrollment_state[]", new Object[]{enrollmentState});
            }
        }
        return this.doGet(builder.build().toUri(), User[].class);
    }

    public Enrollment deleteEnrollment(String courseId, String enrollmentId) {
        URI uri = this.COURSE_DELETE_ENROLLMENTS_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId, enrollmentId});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("task", new Object[]{"delete"});
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            ResponseEntity deleteEnrollmentResponse = this.restTemplate.exchange(builder.build().toUri(), HttpMethod.DELETE, null, Enrollment.class);
            log.debug("{}", (Object)deleteEnrollmentResponse);
            ResponseEntity responseEntity = deleteEnrollmentResponse;
            if (responseEntity.getStatusCode() != HttpStatus.OK) {
                throw new RuntimeException("Request to Canvas was not successful. Response code: " + responseEntity.getStatusCode() + ", reason: " + responseEntity.getStatusCode().getReasonPhrase() + ", body: " + responseEntity.getBody());
            }
            if (deleteEnrollmentResponse != null) {
                return (Enrollment)deleteEnrollmentResponse.getBody();
            }
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error deleting enrollment", (Throwable)hcee);
            throw new RuntimeException("Error deleting enrollment", hcee);
        }
        return null;
    }

    public void hideCourseTool(String courseId, String courseToolId) {
        this.toggleCourseTool(courseId, courseToolId, true);
    }

    public void showCourseTool(String courseId, String courseToolId) {
        this.toggleCourseTool(courseId, courseToolId, false);
    }

    private void toggleCourseTool(@NonNull String courseId, @NonNull String courseToolId, boolean isHidden) {
        if (courseId == null) {
            throw new NullPointerException("courseId is marked non-null but is null");
        }
        if (courseToolId == null) {
            throw new NullPointerException("courseToolId is marked non-null but is null");
        }
        URI uri = this.COURSE_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.path("/tabs");
        builder.path("/" + courseToolId);
        builder.queryParam("hidden", new Object[]{isHidden});
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            ResponseEntity toggleCourseToolResponse = this.restTemplate.exchange(builder.build().toUri(), HttpMethod.PUT, null, String.class);
            log.debug("{}", (Object)toggleCourseToolResponse);
            ResponseEntity responseEntity = toggleCourseToolResponse;
            if (responseEntity.getStatusCode() != HttpStatus.OK) {
                throw new RuntimeException("Request to Canvas was not successful. Response code: " + responseEntity.getStatusCode() + ", reason: " + responseEntity.getStatusCode().getReasonPhrase() + ", body: " + (String)responseEntity.getBody());
            }
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error toggling the course tool", (Throwable)hcee);
            throw new RuntimeException("Error modifying tab/tool", hcee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalCourseToolResult getCourseTool(String courseId, String courseToolId) {
        URI uri = this.COURSE_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.path("/external_tools");
        builder.path("/" + courseToolId);
        ResponseErrorHandler oldResponseErrorHandler = this.restTemplate.getErrorHandler();
        ExternalCourseToolResult externalCourseToolResult = null;
        try {
            ResponseEntity httpEntity;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            this.restTemplate.setErrorHandler((ResponseErrorHandler)new ClientErrorHandler());
            ResponseEntity responseEntity = httpEntity = this.restTemplate.exchange(builder.build().toUri(), HttpMethod.GET, null, ExternalTool.class);
            externalCourseToolResult = new ExternalCourseToolResult(responseEntity.getStatusCode(), responseEntity.getStatusCodeValue(), (ExternalTool)responseEntity.getBody());
        }
        catch (Exception e) {
            log.error("Error ", (Throwable)e);
        }
        finally {
            this.restTemplate.setErrorHandler(oldResponseErrorHandler);
        }
        return externalCourseToolResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalCourseToolResult renameCourseTool(String courseId, String courseToolId, String newToolName) {
        if (newToolName == null || newToolName.trim().length() == 0) {
            return null;
        }
        URI uri = this.COURSE_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.path("/external_tools");
        builder.path("/" + courseToolId);
        ResponseErrorHandler oldResponseErrorHandler = this.restTemplate.getErrorHandler();
        ExternalCourseToolResult externalCourseToolResult = null;
        try {
            ResponseEntity httpEntity;
            this.restTemplate.setErrorHandler((ResponseErrorHandler)new ClientErrorHandler());
            HashMap<String, String> valueMap = new HashMap<String, String>();
            valueMap.put("name", newToolName);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity requestEntity = new HttpEntity(valueMap, (MultiValueMap)headers);
            ResponseEntity responseEntity = httpEntity = this.restTemplate.exchange(builder.build().toUri(), HttpMethod.PUT, requestEntity, ExternalTool.class);
            externalCourseToolResult = new ExternalCourseToolResult(responseEntity.getStatusCode(), responseEntity.getStatusCodeValue(), (ExternalTool)responseEntity.getBody());
        }
        catch (Exception e) {
            log.error("Error ", (Throwable)e);
        }
        finally {
            this.restTemplate.setErrorHandler(oldResponseErrorHandler);
        }
        return externalCourseToolResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalCourseToolResult deleteCourseTool(String courseId, String courseToolId) {
        URI uri = this.COURSE_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.path("/external_tools");
        builder.path("/" + courseToolId);
        ResponseErrorHandler oldResponseErrorHandler = this.restTemplate.getErrorHandler();
        ExternalCourseToolResult externalCourseToolResult = null;
        try {
            ResponseEntity httpEntity;
            this.restTemplate.setErrorHandler((ResponseErrorHandler)new ClientErrorHandler());
            ResponseEntity responseEntity = httpEntity = this.restTemplate.exchange(builder.build().toUri(), HttpMethod.DELETE, null, ExternalTool.class);
            externalCourseToolResult = new ExternalCourseToolResult(responseEntity.getStatusCode(), responseEntity.getStatusCodeValue(), (ExternalTool)responseEntity.getBody());
        }
        catch (Exception e) {
            log.error("Error ", (Throwable)e);
        }
        finally {
            this.restTemplate.setErrorHandler(oldResponseErrorHandler);
        }
        return externalCourseToolResult;
    }

    private class ClientErrorHandler
    extends DefaultResponseErrorHandler {
        private ClientErrorHandler() {
        }

        public void handleError(ClientHttpResponse response) throws IOException {
            log.info("Handling error!!!");
        }
    }

    public static class ExternalCourseToolResult
    implements Serializable {
        public HttpStatus httpStatus;
        public int httpStatusCode;
        public ExternalTool externalTool;

        public HttpStatus getHttpStatus() {
            return this.httpStatus;
        }

        public int getHttpStatusCode() {
            return this.httpStatusCode;
        }

        public ExternalTool getExternalTool() {
            return this.externalTool;
        }

        public void setHttpStatus(HttpStatus httpStatus) {
            this.httpStatus = httpStatus;
        }

        public void setHttpStatusCode(int httpStatusCode) {
            this.httpStatusCode = httpStatusCode;
        }

        public void setExternalTool(ExternalTool externalTool) {
            this.externalTool = externalTool;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExternalCourseToolResult)) {
                return false;
            }
            ExternalCourseToolResult other = (ExternalCourseToolResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getHttpStatusCode() != other.getHttpStatusCode()) {
                return false;
            }
            HttpStatus this$httpStatus = this.getHttpStatus();
            HttpStatus other$httpStatus = other.getHttpStatus();
            if (this$httpStatus == null ? other$httpStatus != null : !this$httpStatus.equals(other$httpStatus)) {
                return false;
            }
            ExternalTool this$externalTool = this.getExternalTool();
            ExternalTool other$externalTool = other.getExternalTool();
            return !(this$externalTool == null ? other$externalTool != null : !((Object)this$externalTool).equals(other$externalTool));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ExternalCourseToolResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getHttpStatusCode();
            HttpStatus $httpStatus = this.getHttpStatus();
            result = result * 59 + ($httpStatus == null ? 43 : $httpStatus.hashCode());
            ExternalTool $externalTool = this.getExternalTool();
            result = result * 59 + ($externalTool == null ? 43 : ((Object)$externalTool).hashCode());
            return result;
        }

        public String toString() {
            return "CourseService.ExternalCourseToolResult(httpStatus=" + this.getHttpStatus() + ", httpStatusCode=" + this.getHttpStatusCode() + ", externalTool=" + this.getExternalTool() + ")";
        }

        public ExternalCourseToolResult(HttpStatus httpStatus, int httpStatusCode, ExternalTool externalTool) {
            this.httpStatus = httpStatus;
            this.httpStatusCode = httpStatusCode;
            this.externalTool = externalTool;
        }
    }
}

