/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.canvas.services;

import edu.iu.uits.lms.canvas.services.SpringBaseService;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.util.UriTemplate;

@Service
public class DeveloperKeyService
extends SpringBaseService {
    private static final Logger log = LoggerFactory.getLogger(DeveloperKeyService.class);
    private static final String CANVAS_BASE_URI = "{url}/api";
    private static final String TOOL_CONFIGURATION_URI = "{url}/api/lti/developer_keys/{id}/tool_configuration";
    private static final UriTemplate TOOL_CONFIGURATION_TEMPLATE = new UriTemplate("{url}/api/lti/developer_keys/{id}/tool_configuration");
    private static final String ACCOUNT_BINDING_URI = "{url}/api/v1/accounts/{account_id}/developer_keys/{id}/developer_key_account_bindings";
    private static final UriTemplate ACCOUNT_BINDING_TEMPLATE = new UriTemplate("{url}/api/v1/accounts/{account_id}/developer_keys/{id}/developer_key_account_bindings");

    public String updateToolConfiguration(String canvasServer, String devKeyId, String jsonBody) {
        URI uri = TOOL_CONFIGURATION_TEMPLATE.expand(new Object[]{canvasServer, devKeyId});
        log.debug("{}", (Object)uri);
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity requestEntity = new HttpEntity((Object)jsonBody, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.PUT, requestEntity, String.class);
            log.debug("{}", (Object)responseEntity);
            if (responseEntity != null) {
                return (String)responseEntity.getBody();
            }
        }
        catch (HttpClientErrorException | HttpServerErrorException hcee) {
            log.error("Unable to PUT the developer key changes", hcee);
        }
        return null;
    }

    public String updateAccountBindings(String canvasServer, String accountId, String devKeyId, boolean on) {
        URI uri = ACCOUNT_BINDING_TEMPLATE.expand(new Object[]{canvasServer, accountId, devKeyId});
        log.debug("{}", (Object)uri);
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        multiValueMap.add((Object)"developer_key_account_binding[workflow_state]", (Object)(on ? "on" : "off"));
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            HttpEntity requestEntity = new HttpEntity((Object)multiValueMap, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, requestEntity, String.class);
            log.debug("{}", (Object)responseEntity);
            if (responseEntity != null) {
                return (String)responseEntity.getBody();
            }
        }
        catch (HttpClientErrorException | HttpServerErrorException hcee) {
            log.error("Unable to PUT the developer key account binding changes", hcee);
        }
        return null;
    }
}

