/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.canvas.services;

import edu.iu.uits.lms.canvas.model.ExternalTool;
import edu.iu.uits.lms.canvas.model.LtiSettings;
import edu.iu.uits.lms.canvas.services.SpringBaseService;
import java.net.URI;
import java.util.List;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

@Service
public class ExternalToolsService
extends SpringBaseService {
    private static final Logger log = LoggerFactory.getLogger(ExternalToolsService.class);
    private static final String CANVAS_BASE_URI = "{url}/api/v1";
    private static final String ACCOUNTS_BASE_URI = "{url}/api/v1/accounts";
    private static final String ACCOUNT_URI = "{url}/api/v1/accounts/{id}";
    private static final String EXTERNAL_TOOLS_URI = "{url}/api/v1/accounts/{id}/external_tools/{toolId}";
    private static final String EXTERNAL_TOOLS_VIA_COURSES_URI = "/courses/{id}/external_tools";
    private static final String EXTERNAL_TOOL_VIA_COURSES_URI = "/courses/{id}/external_tools/{toolId}";
    private static final String EXTERNAL_TOOLS_VIA_ACCOUNTS_URI = "{url}/accounts/{id}/external_tools";
    private static final UriTemplate EXTERNAL_TOOLS_TEMPLATE = new UriTemplate("{url}/api/v1/accounts/{id}/external_tools/{toolId}");
    private static final UriTemplate EXTERNAL_TOOLS_VIA_COURSES_URI_TEMPLATE = new UriTemplate("{url}/courses/{id}/external_tools");
    private static final UriTemplate EXTERNAL_TOOLS_VIA_ACCOUNTS_URI_TEMPLATE = new UriTemplate("{url}/accounts/{id}/external_tools");
    private static final UriTemplate EXTERNAL_TOOL_VIA_COURSES_URI_TEMPLATE = new UriTemplate("{url}/api/v1/courses/{id}/external_tools/{toolId}");

    public ExternalTool getExternalTool(String canvasServer, String accountId, String toolId) {
        URI uri = EXTERNAL_TOOLS_TEMPLATE.expand(new Object[]{canvasServer, accountId, toolId});
        log.debug("{}", (Object)uri);
        try {
            ResponseEntity response = this.restTemplate.getForEntity(uri, ExternalTool.class);
            return (ExternalTool)response.getBody();
        }
        catch (HttpClientErrorException hcee) {
            log.error("Unable to GET the external tool from the uri + " + uri, (Throwable)hcee);
            return null;
        }
    }

    public List<ExternalTool> getExternalTools(@NonNull String courseId) {
        if (courseId == null) {
            throw new NullPointerException("courseId is marked non-null but is null");
        }
        URI uri = EXTERNAL_TOOLS_VIA_COURSES_URI_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("per_page", new Object[]{"100"});
        return this.doGet(builder.build().toUri(), ExternalTool[].class);
    }

    public ExternalTool deleteExternalTool(String courseId, String toolId) {
        URI uri = EXTERNAL_TOOLS_VIA_COURSES_URI_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.path("/" + toolId);
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            ResponseEntity externalToolResponse = this.restTemplate.exchange(builder.build().toUri(), HttpMethod.DELETE, null, ExternalTool.class);
            log.debug("{}", (Object)externalToolResponse);
            ResponseEntity responseEntity = externalToolResponse;
            if (responseEntity.getStatusCode() != HttpStatus.OK) {
                throw new RuntimeException("Request to Canvas was not successful. Response code: " + responseEntity.getStatusCode() + ", reason: " + responseEntity.getStatusCode().getReasonPhrase() + ", body: " + responseEntity.getBody());
            }
            if (externalToolResponse != null) {
                log.info("Deleted ExternalTool toolId " + toolId + " from Canvas courseId: " + courseId);
                return (ExternalTool)externalToolResponse.getBody();
            }
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error deleting external tool", (Throwable)hcee);
            throw new RuntimeException("Error deleting external tool", hcee);
        }
        return null;
    }

    public ExternalTool deleteExternalToolFromAccount(String accountId, String toolId) {
        return this.deleteExternalToolFromAccount(this.canvasConfiguration.getBaseApiUrl(), accountId, toolId);
    }

    public ExternalTool deleteExternalToolFromAccount(String serverUrl, String accountId, String toolId) {
        URI uri = EXTERNAL_TOOLS_VIA_ACCOUNTS_URI_TEMPLATE.expand(new Object[]{serverUrl, accountId});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.path("/" + toolId);
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            log.debug("Uri to DELETE: {}", (Object)builder.build().toUri());
            ResponseEntity externalToolResponse = this.restTemplate.exchange(builder.build().toUri(), HttpMethod.DELETE, null, ExternalTool.class);
            log.debug("{}", (Object)externalToolResponse);
            ResponseEntity responseEntity = externalToolResponse;
            if (responseEntity.getStatusCode() != HttpStatus.OK) {
                throw new RuntimeException("Request to Canvas was not successful. Response code: " + responseEntity.getStatusCode() + ", reason: " + responseEntity.getStatusCode().getReasonPhrase() + ", body: " + responseEntity.getBody());
            }
            if (externalToolResponse != null) {
                log.info("Deleted ExternalTool toolId " + toolId + " from Canvas accountId: " + accountId);
                return (ExternalTool)externalToolResponse.getBody();
            }
        }
        catch (HttpClientErrorException hcee) {
            if (HttpStatus.NOT_FOUND.equals((Object)hcee.getStatusCode())) {
                log.warn("External tool not found for accountId {} and toolId {} on {}", new Object[]{accountId, toolId, serverUrl});
            }
            log.error("Error deleting external tool", (Throwable)hcee);
            throw new RuntimeException("Error deleting external tool", hcee);
        }
        return null;
    }

    public ExternalTool editExternalTool(String courseId, String toolId, String name, String url, boolean isNewTab, boolean isCourseNav) {
        URI uri = EXTERNAL_TOOLS_VIA_COURSES_URI_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.path("/" + toolId);
        builder.queryParam("custom_fields[url]", new Object[]{url});
        builder.queryParam("custom_fields[new_tab]", new Object[]{isNewTab ? 1 : 0});
        if (isCourseNav) {
            builder.queryParam("course_navigation[enabled]", new Object[]{isCourseNav});
        } else {
            builder.queryParam("course_navigation", new Object[]{null});
        }
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        multiValueMap.add((Object)"name", (Object)name);
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            HttpEntity requestEntity = new HttpEntity((Object)multiValueMap, (MultiValueMap)headers);
            ResponseEntity externalToolResponse = this.restTemplate.exchange(builder.build().toUri(), HttpMethod.PUT, requestEntity, ExternalTool.class);
            log.debug("{}", (Object)externalToolResponse);
            ResponseEntity responseEntity = externalToolResponse;
            if (responseEntity.getStatusCode() != HttpStatus.OK) {
                throw new RuntimeException("Request to Canvas was not successful. Response code: " + responseEntity.getStatusCode() + ", reason: " + responseEntity.getStatusCode().getReasonPhrase() + ", body: " + responseEntity.getBody());
            }
            if (externalToolResponse != null) {
                log.info("Edited ExternalTool toolId " + toolId + " from Canvas courseId: " + courseId);
                return (ExternalTool)externalToolResponse.getBody();
            }
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error updating external tool", (Throwable)hcee);
            throw new RuntimeException("Error updating external tool", hcee);
        }
        return null;
    }

    public ExternalTool updateExternalToolForAccount(String canvasServer, String accountId, String toolId, LtiSettings ltiSettings) {
        return this.updateExternalTool(canvasServer, accountId, toolId, ltiSettings, EXTERNAL_TOOLS_TEMPLATE);
    }

    public ExternalTool updateExternalToolForCourse(String canvasServer, String courseId, String toolId, LtiSettings ltiSettings) {
        return this.updateExternalTool(canvasServer, courseId, toolId, ltiSettings, EXTERNAL_TOOL_VIA_COURSES_URI_TEMPLATE);
    }

    private ExternalTool updateExternalTool(String canvasServer, String contextId, String toolId, LtiSettings ltiSettings, UriTemplate uriTemplate) {
        URI uri = uriTemplate.expand(new Object[]{canvasServer, contextId, toolId});
        log.debug("{}", (Object)uri);
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity requestEntity = new HttpEntity((Object)ltiSettings, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.PUT, requestEntity, ExternalTool.class);
            log.debug("{}", (Object)responseEntity);
            if (responseEntity != null) {
                return (ExternalTool)responseEntity.getBody();
            }
        }
        catch (HttpClientErrorException | HttpServerErrorException hcee) {
            log.error("Unable to PUT the external tool changes", hcee);
        }
        return null;
    }
}

