/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.canvas.services;

import edu.iu.uits.lms.canvas.model.CanvasFile;
import edu.iu.uits.lms.canvas.model.CanvasFileUploadResponse;
import edu.iu.uits.lms.canvas.services.SpringBaseService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

@Service
public class FileUploadService
extends SpringBaseService {
    private static final Logger log = LoggerFactory.getLogger(FileUploadService.class);
    private static final String BASE_URI = "{url}";
    private static final String COURSES_URI = "{url}/courses/{course_id}";
    private static final String USERS_URI = "{url}/users/{user_id}";
    private static final String FILES_PATH = "/files";
    private static final UriTemplate COURSE_FILE_TEMPLATE = new UriTemplate("{url}/courses/{course_id}/files");
    private static final UriTemplate USER_FILE_TEMPLATE = new UriTemplate("{url}/users/{user_id}/files");
    private static final String CONVERSATIONS_FOLDER = "conversation attachments";

    public CanvasFile uploadCourseFile(String courseId, String fileName, long fileSize, String contentTypeString, String parentFolderPath, MultipartFile multipartFile, boolean overwriteDuplicate) {
        URI courseFileUri = COURSE_FILE_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId});
        CanvasFileUploadResponse response = this.initiateFileUpload(courseFileUri, fileName, fileSize, contentTypeString, parentFolderPath, overwriteDuplicate, null);
        File file = null;
        if (multipartFile != null) {
            try {
                file = new File(multipartFile.getOriginalFilename());
                file.createNewFile();
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(multipartFile.getBytes());
                fos.close();
            }
            catch (IOException e) {
                log.error("Error: ", (Throwable)e);
                file = null;
            }
        }
        return this.uploadFileToCanvas(response, file);
    }

    public CanvasFile uploadConversationFile(String userId, String fileName, long fileSize, String contentTypeString, File file, boolean overwriteDuplicate) {
        URI conversationFileUri = USER_FILE_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), userId});
        CanvasFileUploadResponse response = this.initiateFileUpload(conversationFileUri, fileName, fileSize, contentTypeString, CONVERSATIONS_FOLDER, overwriteDuplicate, userId);
        return this.uploadFileToCanvas(response, file);
    }

    private CanvasFileUploadResponse initiateFileUpload(URI expandedUri, String fileName, long fileSize, String contentType, String parentFolderPath, boolean overwriteDuplicate, String asUser) {
        String onDuplicate = overwriteDuplicate ? "overwrite" : "rename";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)expandedUri);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"name", (Object)fileName);
        map.add((Object)"size", (Object)String.valueOf(fileSize));
        map.add((Object)"content_type", (Object)contentType);
        map.add((Object)"parent_folder_path", (Object)parentFolderPath);
        map.add((Object)"on_duplicate", (Object)onDuplicate);
        if (asUser != null) {
            map.add((Object)"as_user_id", (Object)asUser);
        }
        HttpEntity requestEntity = new HttpEntity((Object)map, (MultiValueMap)headers);
        CanvasFileUploadResponse uploadResponse = null;
        try {
            ResponseEntity response = this.restTemplate.postForEntity(builder.build().toUri(), (Object)requestEntity, CanvasFileUploadResponse.class);
            uploadResponse = (CanvasFileUploadResponse)response.getBody();
        }
        catch (HttpClientErrorException hcee) {
            log.error("Unable to initiate file upload.", (Throwable)hcee);
            throw new RuntimeException("Unable to initiate file upload to Canvas.");
        }
        return uploadResponse;
    }

    private CanvasFile uploadFileToCanvas(CanvasFileUploadResponse fileUploadResponse, File file) {
        CanvasFile canvasFile;
        block7: {
            canvasFile = null;
            String uri = fileUploadResponse.getUploadUrl();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.MULTIPART_FORM_DATA);
            LinkedMultiValueMap map = new LinkedMultiValueMap();
            for (Map.Entry<String, String> entry : fileUploadResponse.getUploadParams().entrySet()) {
                map.add((Object)entry.getKey(), (Object)entry.getValue());
            }
            FileSystemResource fileAsResource = new FileSystemResource(file);
            map.add((Object)"file", (Object)fileAsResource);
            HttpEntity requestEntity = new HttpEntity((Object)map, (MultiValueMap)headers);
            try {
                ResponseEntity responseEntity = this.restTemplateNoBuffer.postForEntity(uri, (Object)requestEntity, Object.class, new Object[0]);
                HttpStatus httpStatus = responseEntity.getStatusCode();
                if (httpStatus.equals((Object)HttpStatus.OK)) {
                    canvasFile = (CanvasFile)responseEntity.getBody();
                    break block7;
                }
                if (httpStatus.equals((Object)HttpStatus.CREATED) || httpStatus.is3xxRedirection()) {
                    String location = responseEntity.getHeaders().getFirst("location");
                    if (location != null) {
                        canvasFile = this.verifyUpload(location);
                        break block7;
                    }
                    String exception = "No location returned by Canvas to complete upload despite status " + responseEntity.getStatusCodeValue();
                    log.error(exception);
                    throw new RuntimeException(exception);
                }
                String errorEntity = null;
                if (responseEntity.hasBody()) {
                    errorEntity = responseEntity.getBody().toString();
                }
                throw new RuntimeException("File Upload to Canvas was not successful. Response code: " + responseEntity.getStatusCodeValue() + ", reason: " + httpStatus.getReasonPhrase() + ", entity: " + errorEntity);
            }
            catch (Exception error) {
                String exception = "An unexpected error occurred uploading a file to Canvas. File size: " + file.length() + " File name: " + file.getName();
                log.error(exception);
                throw new RuntimeException(exception, error);
            }
        }
        return canvasFile;
    }

    private CanvasFile verifyUpload(String location) {
        CanvasFile canvasFile = null;
        try {
            ResponseEntity fileUploadResponseEntity = this.restTemplate.getForEntity(location, CanvasFile.class, new Object[0]);
            log.debug("fileUploadResponseEntity: {}", (Object)fileUploadResponseEntity);
            if (fileUploadResponseEntity != null) {
                canvasFile = (CanvasFile)fileUploadResponseEntity.getBody();
            }
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error:", (Throwable)hcee);
        }
        return canvasFile;
    }
}

