/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.canvas.services;

import edu.iu.uits.lms.canvas.model.User;
import edu.iu.uits.lms.canvas.model.groups.CourseGroup;
import edu.iu.uits.lms.canvas.services.SpringBaseService;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

@Service
public class GroupService
extends SpringBaseService {
    private static final Logger log = LoggerFactory.getLogger(GroupService.class);
    private static final String BASE_URI = "{url}/";
    private static final String GROUP_URI = "{url}/groups/{group_id}";
    private static final String GROUP_MEMBERSHIP_URI = "{url}/groups/{group_id}/users";
    private static final String COURSE_GROUPS_URI = "{url}/courses/{course_id}/groups";
    private static final String ACCOUNT_GROUPS_URI = "{url}/accounts/{account_id}/groups";
    private static final UriTemplate GROUP_TEMPLATE = new UriTemplate("{url}/groups/{group_id}");
    private static final UriTemplate GROUP_MEMBERSHIP_TEMPLATE = new UriTemplate("{url}/groups/{group_id}/users");
    private static final UriTemplate COURSE_GROUPS_TEMPLATE = new UriTemplate("{url}/courses/{course_id}/groups");
    private static final UriTemplate ACCOUNT_GROUPS_TEMPLATE = new UriTemplate("{url}/accounts/{account_id}/groups");

    public CourseGroup getCourseGroup(String groupId) {
        if (groupId == null) {
            return null;
        }
        URI uri = GROUP_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), groupId});
        log.debug("{}", (Object)uri);
        try {
            ResponseEntity groupEntity = this.restTemplate.getForEntity(uri, CourseGroup.class);
            log.debug("{}", (Object)groupEntity);
            if (groupEntity != null) {
                return (CourseGroup)groupEntity.getBody();
            }
        }
        catch (HttpClientErrorException hcee) {
            log.error("error getting a course group: ", (Throwable)hcee);
        }
        return null;
    }

    public List<CourseGroup> getGroupsForCourse(String courseId) {
        List<CourseGroup> groups = new ArrayList<CourseGroup>();
        if (courseId != null) {
            URI uri = COURSE_GROUPS_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId});
            log.debug("{}", (Object)uri);
            groups = this.doGet(uri, CourseGroup[].class);
        }
        return groups;
    }

    public List<User> getUsersInGroup(String groupId, boolean excludeInactive) {
        if (groupId == null) {
            return new ArrayList<User>();
        }
        URI uri = GROUP_MEMBERSHIP_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), groupId});
        log.debug("{}", (Object)uri);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("exclude_inactive", new Object[]{excludeInactive});
        return this.doGet(builder.build().toUri(), User[].class);
    }
}

