/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.canvas.services;

import edu.iu.uits.lms.canvas.model.uploadstatus.CanvasUploadStatus;
import edu.iu.uits.lms.canvas.model.uploadstatus.CanvasUploadStatusWrapper;
import edu.iu.uits.lms.canvas.services.SpringBaseService;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

@Service
public class ImportService
extends SpringBaseService {
    private static final Logger log = LoggerFactory.getLogger(ImportService.class);
    private static final String BASE_URI = "{url}/accounts/{accountId}";
    private static final String UPLOAD_URI = "{url}/accounts/{accountId}/sis_imports.json";
    private static final String SIS_IMPORT_BASE = "{url}/accounts/{accountId}/sis_imports";
    private static final String SIS_IMPORT = "{url}/accounts/{accountId}/sis_imports/{id}";
    private static final UriTemplate UPLOAD_TEMPLATE = new UriTemplate("{url}/accounts/{accountId}/sis_imports.json");
    private static final UriTemplate SIS_IMPORTS_TEMPLATE = new UriTemplate("{url}/accounts/{accountId}/sis_imports");
    private static final UriTemplate SIS_IMPORT_TEMPLATE = new UriTemplate("{url}/accounts/{accountId}/sis_imports/{id}");

    public String sendCsvToCanvas(MultipartFile file) {
        try {
            return this.sendFileToCanvas(file.getBytes(), "instructure_csv", "csv", false);
        }
        catch (IOException e) {
            log.error("unable to send file to canvas", (Throwable)e);
            return null;
        }
    }

    public String sendZipToCanvas(byte[] bytes) {
        return this.sendFileToCanvas(bytes, "instructure_csv", "zip", false);
    }

    public String sendZipToCanvasOverrideStickiness(byte[] bytes) {
        return this.sendFileToCanvas(bytes, "instructure_csv", "zip", true);
    }

    private String sendFileToCanvas(byte[] fileBytes, String importType, String extension, boolean overrideStickiness) {
        URI uri = UPLOAD_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), this.canvasConfiguration.getAccountId()});
        log.debug("{}", (Object)uri);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("import_type", new Object[]{importType});
        builder.queryParam("extension", new Object[]{extension});
        if (overrideStickiness) {
            builder.queryParam("override_sis_stickiness", new Object[]{true});
            builder.queryParam("clear_sis_stickiness", new Object[]{true});
        }
        HttpHeaders headers = new HttpHeaders();
        try {
            HttpEntity requestEntity = new HttpEntity((Object)fileBytes, (MultiValueMap)headers);
            CanvasUploadStatus sisImport = (CanvasUploadStatus)this.restTemplate.postForObject(builder.build().toUri(), (Object)requestEntity, CanvasUploadStatus.class);
            return sisImport.getId();
        }
        catch (Exception e) {
            log.error("unable to send file to canvas", (Throwable)e);
            return null;
        }
    }

    public CanvasUploadStatus getImportStatus(String importId) {
        URI uri = SIS_IMPORT_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), this.canvasConfiguration.getAccountId(), importId});
        log.debug("{}", (Object)uri);
        try {
            ResponseEntity entity = this.restTemplate.getForEntity(uri, CanvasUploadStatus.class);
            log.debug("{}", (Object)entity);
            if (entity != null) {
                return (CanvasUploadStatus)entity.getBody();
            }
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error getting the import status for " + importId, (Throwable)hcee);
        }
        return null;
    }

    public List<CanvasUploadStatus> getImports(String createdSince, List<String> workflowStates) {
        URI uri = SIS_IMPORTS_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), this.canvasConfiguration.getAccountId()});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        if (createdSince != null) {
            builder.queryParam("created_since", new Object[]{createdSince});
        }
        if (workflowStates != null && !workflowStates.isEmpty()) {
            for (String state : workflowStates) {
                builder.queryParam("workflow_state[]", new Object[]{state});
            }
        }
        log.debug("{}", (Object)builder.build().toUri());
        List<CanvasUploadStatusWrapper> sisImports = this.doGetSingle(builder.build().toUri(), CanvasUploadStatusWrapper.class);
        ArrayList<CanvasUploadStatus> imports = new ArrayList<CanvasUploadStatus>();
        if (sisImports != null && !sisImports.isEmpty()) {
            sisImports.stream().map(CanvasUploadStatusWrapper::getSisImports).filter(sisImports1SisImports -> !sisImports1SisImports.isEmpty()).forEach(imports::addAll);
        } else {
            log.warn("No sis imports returned.");
        }
        return imports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readArchive(String filePath) {
        File file = new File(filePath);
        byte[] result = new byte[(int)file.length()];
        InputStream input = null;
        try {
            int totalBytesRead = 0;
            input = new BufferedInputStream(new FileInputStream(file));
            while (totalBytesRead < result.length) {
                int bytesRemaining = result.length - totalBytesRead;
                int bytesRead = input.read(result, totalBytesRead, bytesRemaining);
                if (bytesRead <= 0) continue;
                totalBytesRead += bytesRead;
            }
        }
        catch (IOException e) {
            log.error("Error reading archive", (Throwable)e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    log.error("Error closing stream", (Throwable)e);
                }
            }
        }
        return result;
    }
}

