/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.canvas.services;

import edu.iu.uits.lms.canvas.model.Quiz;
import edu.iu.uits.lms.canvas.model.QuizSubmission;
import edu.iu.uits.lms.canvas.model.QuizSubmissionWrapper;
import edu.iu.uits.lms.canvas.services.SpringBaseService;
import java.net.URI;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

@Service
public class QuizService
extends SpringBaseService {
    private static final Logger log = LoggerFactory.getLogger(QuizService.class);
    private static final String COURSES_BASE_URI = "{url}/courses";
    private static final String COURSE_QUIZZES_URI = "{url}/courses/{id}/quizzes";
    private static final String SINGLE_QUIZ_URI = "{url}/courses/{id}/quizzes/{id}";
    private static final String QUIZ_SUBMISSION_URI = "{url}/courses/{id}/quizzes/{id}/submission";
    private UriTemplate COURSE_QUIZZES_TEMPLATE = new UriTemplate("{url}/courses/{id}/quizzes");
    private UriTemplate SINGLE_QUIZ_TEMPLATE = new UriTemplate("{url}/courses/{id}/quizzes/{id}");
    private UriTemplate QUIZ_SUBMISSION_TEMPLATE = new UriTemplate("{url}/courses/{id}/quizzes/{id}/submission");

    public List<Quiz> getQuizzesInCourse(String courseId, String sis_login_id) {
        URI uri = this.COURSE_QUIZZES_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("as_user_id", new Object[]{"sis_login_id:" + sis_login_id});
        builder.queryParam("per_page", new Object[]{"100"});
        return this.doGet(builder.build().toUri(), Quiz[].class);
    }

    public Quiz getSingleQuizFromCourse(String courseId, String quizId, String sis_login_id) {
        URI uri = this.SINGLE_QUIZ_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId, quizId});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("as_user_id", new Object[]{"sis_login_id:" + sis_login_id});
        try {
            ResponseEntity quizResponseEntity = this.restTemplate.getForEntity(builder.build().toUri(), Quiz.class);
            log.debug("quizResponseEntity: {}", (Object)quizResponseEntity);
            if (quizResponseEntity != null) {
                return (Quiz)quizResponseEntity.getBody();
            }
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error:", (Throwable)hcee);
        }
        return null;
    }

    public List<QuizSubmission> getQuizSubmissionFromQuiz(String courseId, String quizId, String sis_login_id) {
        URI uri = this.QUIZ_SUBMISSION_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId, quizId});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("as_user_id", new Object[]{"sis_login_id:" + sis_login_id});
        try {
            ResponseEntity quizResponseEntity = this.restTemplate.getForEntity(builder.build().toUri(), QuizSubmissionWrapper.class);
            log.debug("quizResponseEntity: {}", (Object)quizResponseEntity);
            if (quizResponseEntity != null) {
                return ((QuizSubmissionWrapper)quizResponseEntity.getBody()).getQuizSubmissions();
            }
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error:", (Throwable)hcee);
        }
        return null;
    }
}

