/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.canvas.services;

import edu.iu.uits.lms.canvas.model.CourseSectionUpdateWrapper;
import edu.iu.uits.lms.canvas.model.Enrollment;
import edu.iu.uits.lms.canvas.model.Section;
import edu.iu.uits.lms.canvas.services.SpringBaseService;
import java.net.URI;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

@Service
public class SectionService
extends SpringBaseService {
    private static final Logger log = LoggerFactory.getLogger(SectionService.class);
    private static final String BASE_URI = "{url}/sections";
    private static final String SECTION_URI = "{url}/sections/{id}";
    private static final String CROSSLIST_BASE_URI = "{url}/sections/{id}/crosslist";
    private static final String CROSSLIST_URI = "{url}/sections/{id}/crosslist/{parent_id}";
    private static final String STUDENT_SECTION_ENROLLMENT_URI = "{url}/sections/{sis_section_id}/enrollments";
    private static final String ALL_SECTION_ENROLLMENT_URI = "{url}/sections/{section_id}/enrollments";
    private static final UriTemplate SECTION_TEMPLATE = new UriTemplate("{url}/sections/{id}");
    private static final UriTemplate CROSSLIST_TEMPLATE = new UriTemplate("{url}/sections/{id}/crosslist/{parent_id}");
    private static final UriTemplate CROSSLIST_BASE_TEMPLATE = new UriTemplate("{url}/sections/{id}/crosslist");
    private static final UriTemplate STUDENT_SECTION_ENROLLMENT_TEMPLATE = new UriTemplate("{url}/sections/{sis_section_id}/enrollments");
    private static final UriTemplate ALL_SECTION_ENROLLMENT_TEMPLATE = new UriTemplate("{url}/sections/{section_id}/enrollments");

    public Section getSection(String id) {
        URI uri = SECTION_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), id});
        log.debug("uri: {}", (Object)uri);
        try {
            ResponseEntity sectionEntity = this.restTemplate.getForEntity(uri, Section.class);
            log.debug("sectionEntity: {}", (Object)sectionEntity);
            if (sectionEntity != null) {
                return (Section)sectionEntity.getBody();
            }
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error: ", (Throwable)hcee);
        }
        return null;
    }

    public Section crossList(String sectionId, String parentCourseId) {
        URI uri = CROSSLIST_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), sectionId, parentCourseId});
        log.debug("uri: {}", (Object)uri);
        try {
            ResponseEntity sectionEntity = this.restTemplate.postForEntity(uri, null, Section.class);
            log.debug("sectionEntity: {}", (Object)sectionEntity);
            if (sectionEntity != null) {
                Section section = (Section)sectionEntity.getBody();
                if (section != null && section.getId() == null) {
                    section = null;
                }
                return section;
            }
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error: ", (Throwable)hcee);
        }
        return null;
    }

    public Section decrossList(String sectionId) {
        URI uri = CROSSLIST_BASE_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), sectionId});
        log.debug("uri: {}", (Object)uri);
        try {
            ResponseEntity sectionEntity = this.restTemplate.exchange(uri, HttpMethod.DELETE, null, Section.class);
            log.debug("sectionEntity: {}", (Object)sectionEntity);
            if (sectionEntity != null) {
                Section section = (Section)sectionEntity.getBody();
                if (section != null && section.getId() == null) {
                    section = null;
                }
                return section;
            }
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error: ", (Throwable)hcee);
        }
        return null;
    }

    public List<Enrollment> getStudentSectionEnrollments(String sisSectionId) {
        String sisSectionIdPath = "sis_section_id:" + sisSectionId;
        URI uri = STUDENT_SECTION_ENROLLMENT_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), sisSectionIdPath});
        log.debug("{}", (Object)uri);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("type[]", new Object[]{"StudentEnrollment"});
        builder.queryParam("per_page", new Object[]{"50"});
        builder.queryParam("state[]", new Object[]{"active"});
        return this.doGet(builder.build().toUri(), Enrollment[].class);
    }

    public List<Enrollment> getAllSectionEnrollmentsByIdAndState(String sectionId, String[] states) {
        String sisSectionIdPath = sectionId;
        URI uri = ALL_SECTION_ENROLLMENT_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), sisSectionIdPath});
        log.debug("{}", (Object)uri);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("per_page", new Object[]{"50"});
        if (states != null) {
            builder.queryParam("state[]", (Object[])states);
        }
        return this.doGet(builder.build().toUri(), Enrollment[].class);
    }

    public Section updateSectionNameAndSisCourseId(String sectionId, CourseSectionUpdateWrapper courseSectionUpdateWrapper) {
        if (sectionId == null) {
            throw new IllegalArgumentException("Null id passed to updateSectionNameAndSisCourseId.");
        }
        URI uri = SECTION_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), sectionId});
        log.debug("uri: {}", (Object)uri);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        multiValueMap.add((Object)"course_section[name]", (Object)courseSectionUpdateWrapper.getName());
        multiValueMap.add((Object)"course_section[sis_section_id]", (Object)courseSectionUpdateWrapper.getSisId());
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            HttpEntity requestEntity = new HttpEntity((Object)multiValueMap, (MultiValueMap)headers);
            ResponseEntity updateSectionNameAndSisCourseIdResponse = this.restTemplate.exchange(builder.build().toUri(), HttpMethod.PUT, requestEntity, Section.class);
            log.debug("{}", (Object)updateSectionNameAndSisCourseIdResponse);
            ResponseEntity responseEntity = updateSectionNameAndSisCourseIdResponse;
            if (responseEntity.getStatusCode() != HttpStatus.OK) {
                throw new RuntimeException("Request to Canvas was not successful. Response code: " + responseEntity.getStatusCode() + ", reason: " + responseEntity.getStatusCode().getReasonPhrase() + ", body: " + responseEntity.getBody());
            }
            return (Section)updateSectionNameAndSisCourseIdResponse.getBody();
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error updating section name and sis_course_id", (Throwable)hcee);
            return null;
        }
    }
}

