/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.canvas.services;

import edu.iu.uits.lms.canvas.config.CanvasConfiguration;
import edu.iu.uits.lms.canvas.services.BaseService;
import edu.iu.uits.lms.canvas.utils.LinkHeaderParser;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

@Service(value="SpringBaseService")
public class SpringBaseService
extends BaseService {
    private static final Logger log = LoggerFactory.getLogger(SpringBaseService.class);
    @Autowired
    @Qualifier(value="CanvasRestTemplate")
    protected RestTemplate restTemplate;
    @Autowired
    @Qualifier(value="restTemplateNoBuffer")
    protected RestTemplate restTemplateNoBuffer;
    @Autowired
    protected CanvasConfiguration canvasConfiguration;

    protected <T> List<T> doGet(URI uri, Class<T[]> setType) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        try {
            String nextLink;
            log.debug("{}", (Object)uri);
            ResponseEntity entity = this.restTemplate.getForEntity(uri, setType);
            LinkHeaderParser lhp = new LinkHeaderParser(entity.getHeaders());
            resultList.addAll(Arrays.asList((Object[])entity.getBody()));
            if (lhp.hasLinkHeader() && (nextLink = lhp.getNext()) != null) {
                try {
                    resultList.addAll(this.doGet(new URI(nextLink), setType));
                }
                catch (URISyntaxException e) {
                    log.error("error parsing uri");
                }
            }
        }
        catch (HttpStatusCodeException e) {
            log.warn("uh oh", (Throwable)e);
        }
        return resultList;
    }

    protected <T> List<T> doGetSingle(URI uri, Class<T> setType) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        try {
            String nextLink;
            ResponseEntity entity = this.restTemplate.getForEntity(uri, setType);
            LinkHeaderParser lhp = new LinkHeaderParser(entity.getHeaders());
            resultList.add(entity.getBody());
            if (lhp.hasLinkHeader() && (nextLink = lhp.getNext()) != null) {
                try {
                    resultList.addAll(this.doGetSingle(new URI(nextLink), setType));
                }
                catch (URISyntaxException e) {
                    log.error("error parsing uri");
                }
            }
        }
        catch (HttpStatusCodeException e) {
            log.warn("Error occurred attempting to paginate through dataset", (Throwable)e);
        }
        return resultList;
    }
}

