/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.canvas.services;

import edu.iu.uits.lms.canvas.model.CanvasEnrollmentTerms;
import edu.iu.uits.lms.canvas.model.CanvasTerm;
import edu.iu.uits.lms.canvas.model.CanvasTermCreateWrapper;
import edu.iu.uits.lms.canvas.services.SpringBaseService;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

@Service
public class TermService
extends SpringBaseService {
    private static final Logger log = LoggerFactory.getLogger(TermService.class);
    private static final String TERMS_URI = "{url}/accounts/{account_id}/terms";
    private static final UriTemplate TERMS_TEMPLATE = new UriTemplate("{url}/accounts/{account_id}/terms");

    @Cacheable(value={"EnrollmentTerms"}, cacheManager="CanvasServicesCacheManager")
    public List<CanvasTerm> getEnrollmentTerms() {
        URI uri = TERMS_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), this.canvasConfiguration.getAccountId()});
        log.debug("{}", (Object)uri);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("per_page", new Object[]{"50"});
        builder.queryParam("include[]", new Object[]{"overrides"});
        List<CanvasEnrollmentTerms> termsList = this.doGetSingle(builder.build().toUri(), CanvasEnrollmentTerms.class);
        ArrayList<CanvasTerm> terms = new ArrayList<CanvasTerm>();
        if (termsList != null && !termsList.isEmpty()) {
            for (CanvasEnrollmentTerms canvasTermList : termsList) {
                terms.addAll(canvasTermList.getEnrollmentTerms());
            }
        } else {
            log.warn("No enrollment terms returned.");
        }
        return terms;
    }

    public CanvasTerm getTermById(String termId) {
        List<CanvasTerm> allTerms = this.getEnrollmentTerms();
        return allTerms.stream().filter(term -> termId.equals(term.getId())).findFirst().orElse(null);
    }

    public CanvasTerm getTermBySisId(String sisTermId) {
        List<CanvasTerm> allTerms = this.getEnrollmentTerms();
        return allTerms.stream().filter(term -> sisTermId.equals(term.getSisTermId())).findAny().orElse(null);
    }

    public CanvasTerm getCurrentYearTerm() {
        CanvasTerm currentYearTerm = null;
        Calendar cal = Calendar.getInstance();
        String year = String.valueOf(cal.get(1));
        boolean createNewTerm = true;
        List<CanvasTerm> enrollmentTerms = this.getEnrollmentTerms();
        for (CanvasTerm canvasTerm : enrollmentTerms) {
            if (!year.equals(canvasTerm.getSisTermId())) continue;
            currentYearTerm = canvasTerm;
            createNewTerm = false;
            break;
        }
        if (createNewTerm) {
            CanvasTerm newTerm = new CanvasTerm();
            newTerm.setSisTermId(year);
            newTerm.setName(year);
            newTerm.setStartAt(year + "-01-01T05:00:00Z");
            newTerm.setEndAt(year + "-12-31T05:00:00Z");
            CanvasTermCreateWrapper termWrapper = new CanvasTermCreateWrapper();
            termWrapper.setEnrollmentTerm(newTerm);
            currentYearTerm = this.createCanvasTerm(termWrapper);
        }
        return currentYearTerm;
    }

    public CanvasTerm createCanvasTerm(CanvasTermCreateWrapper newTerm) {
        CanvasTerm savedTerm = null;
        URI uri = TERMS_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), this.canvasConfiguration.getAccountId()});
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity termCreateWrapperRequestEntity = new HttpEntity((Object)newTerm, (MultiValueMap)headers);
            ResponseEntity createTermResponse = this.restTemplate.exchange(uri, HttpMethod.POST, termCreateWrapperRequestEntity, CanvasTerm.class);
            log.debug("{}", (Object)createTermResponse);
            HttpStatus responseStatus = createTermResponse.getStatusCode();
            if (HttpStatus.OK.equals((Object)responseStatus)) {
                savedTerm = (CanvasTerm)createTermResponse.getBody();
            } else {
                log.error("Error creating enrollment term. Request to Canvas was not successful. Response code: " + responseStatus + ", reason: " + responseStatus.getReasonPhrase() + ", entity: " + (HttpEntity)createTermResponse);
            }
        }
        catch (HttpClientErrorException hcee) {
            log.error("uh oh", (Throwable)hcee);
        }
        return savedTerm;
    }
}

