/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.canvas.services;

import edu.iu.uits.lms.canvas.model.CanvasLogin;
import edu.iu.uits.lms.canvas.model.CommunicationChannel;
import edu.iu.uits.lms.canvas.model.JsonUser;
import edu.iu.uits.lms.canvas.model.License;
import edu.iu.uits.lms.canvas.model.LoginWrapper;
import edu.iu.uits.lms.canvas.model.PostedLogin;
import edu.iu.uits.lms.canvas.model.PostedUser;
import edu.iu.uits.lms.canvas.model.Profile;
import edu.iu.uits.lms.canvas.model.QuotaInfo;
import edu.iu.uits.lms.canvas.model.User;
import edu.iu.uits.lms.canvas.model.UserCustomDataRequest;
import edu.iu.uits.lms.canvas.services.SpringBaseService;
import java.io.Serializable;
import java.net.URI;
import java.util.List;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

@Service
public class UserService
extends SpringBaseService {
    private static final Logger log = LoggerFactory.getLogger(UserService.class);
    private static final String USERS_URI = "{url}/users/{id}";
    private static final String CUSTOM_DATA_URI = "{url}/users/{id}/custom_data";
    private static final String ACCOUNTS_USERS_URI = "{url}/accounts/{accountId}/users";
    private static final String LICENSE_URI = "{url}/users/{id}/content_licenses";
    private static final String LOGINS_BASE_URI = "{url}/accounts/{accountId}/logins";
    private static final String LOGIN_URI = "{url}/accounts/{accountId}/logins/{loginId}";
    private static final String LOGINS_URI = "{url}/users/{id}/logins";
    private static final String PROFILE_URI = "{url}/users/{id}/profile";
    private static final String QUOTA_URI = "{url}/users/{id}/files/quota";
    private static final UriTemplate CUSTOM_DATA_TEMPLATE = new UriTemplate("{url}/users/{id}/custom_data");
    private static final UriTemplate ACCOUNTS_USERS_TEMPLATE = new UriTemplate("{url}/accounts/{accountId}/users");
    private static final UriTemplate LICENSE_TEMPLATE = new UriTemplate("{url}/users/{id}/content_licenses");
    private static final UriTemplate LOGINS_BASE_TEMPLATE = new UriTemplate("{url}/accounts/{accountId}/logins");
    private static final UriTemplate LOGINS_TEMPLATE = new UriTemplate("{url}/users/{id}/logins");
    private static final UriTemplate LOGIN_TEMPLATE = new UriTemplate("{url}/accounts/{accountId}/logins/{loginId}");
    private static final UriTemplate USERS_TEMPLATE = new UriTemplate("{url}/users/{id}");
    private static final UriTemplate PROFILE_TEMPLATE = new UriTemplate("{url}/users/{id}/profile");
    private static final UriTemplate QUOTA_TEMPLATE = new UriTemplate("{url}/users/{id}/files/quota");

    public QuotaInfo getUserQuotaInfo(@NonNull String userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        URI uri = QUOTA_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), userId});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("as_user_id", new Object[]{userId});
        try {
            return (QuotaInfo)this.restTemplate.getForObject(builder.build().toUri(), QuotaInfo.class);
        }
        catch (HttpClientErrorException hcee) {
            log.error("Request to Canvas was not successful. Response code: " + hcee.getStatusCode() + ", reason: " + hcee.getStatusText() + ", entity: " + hcee.getResponseBodyAsString());
            return null;
        }
    }

    public Object getUserCustomData(UserCustomDataRequest userCustomDataRequest) {
        String userPath = this.buildAlternateId(userCustomDataRequest.getUserId(), userCustomDataRequest.getField());
        URI uri = CUSTOM_DATA_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), userPath});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("ns", new Object[]{"edu.iu.uits.lms"});
        for (String path : userCustomDataRequest.getPathParts()) {
            builder.pathSegment(new String[]{path});
        }
        log.debug("{}", (Object)builder.build().toUri());
        try {
            ResponseEntity response = this.restTemplate.getForEntity(builder.build().toUri(), Object.class);
            log.debug("{}", (Object)response);
            return response.getBody();
        }
        catch (HttpClientErrorException hcee) {
            log.error("Request to Canvas was not successful. Response code: " + hcee.getStatusCode() + ", reason: " + hcee.getStatusText() + ", entity: " + hcee.getResponseBodyAsString(), (Throwable)hcee);
            return null;
        }
    }

    public Object setUserCustomData(UserCustomDataRequest userCustomDataRequest) {
        String userPath = this.buildAlternateId(userCustomDataRequest.getUserId(), userCustomDataRequest.getField());
        URI uri = CUSTOM_DATA_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), userPath});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        for (String path : userCustomDataRequest.getPathParts()) {
            builder.pathSegment(new String[]{path});
        }
        try {
            LinkedMultiValueMap map = new LinkedMultiValueMap();
            map.add((Object)"ns", (Object)"edu.iu.uits.lms");
            map.add((Object)"data", (Object)userCustomDataRequest.getData());
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            HttpEntity requestEntity = new HttpEntity((Object)map, (MultiValueMap)headers);
            log.debug("{}", (Object)requestEntity);
            ResponseEntity response = this.restTemplate.exchange(builder.build().toUri(), HttpMethod.PUT, requestEntity, Object.class);
            log.debug("{}", (Object)response);
            return response.getBody();
        }
        catch (HttpClientErrorException hcee) {
            log.error("Request to Canvas was not successful. Response code: " + hcee.getStatusCode() + ", reason: " + hcee.getStatusText() + ", entity: " + hcee.getResponseBodyAsString(), (Throwable)hcee);
            return null;
        }
    }

    public Object deleteUserCustomData(UserCustomDataRequest userCustomDataRequest) {
        String userPath = this.buildAlternateId(userCustomDataRequest.getUserId(), userCustomDataRequest.getField());
        URI uri = CUSTOM_DATA_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), userPath});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        for (String path : userCustomDataRequest.getPathParts()) {
            builder.pathSegment(new String[]{path});
        }
        try {
            LinkedMultiValueMap map = new LinkedMultiValueMap();
            map.add((Object)"ns", (Object)"edu.iu.uits.lms");
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            HttpEntity requestEntity = new HttpEntity((Object)map, (MultiValueMap)headers);
            log.debug("{}", (Object)requestEntity);
            ResponseEntity response = this.restTemplate.exchange(builder.build().toUri(), HttpMethod.DELETE, requestEntity, Object.class);
            log.debug("{}", (Object)response);
            return response.getBody();
        }
        catch (HttpClientErrorException hcee) {
            log.error("Request to Canvas was not successful. Response code: " + hcee.getStatusCode() + ", reason: " + hcee.getStatusText() + ", entity: " + hcee.getResponseBodyAsString(), (Throwable)hcee);
            return null;
        }
    }

    public List<CanvasLogin> getGuestUserLogins(String loginId) {
        String firstIdCheck = "sis_user_id:" + loginId;
        String secondIdCheck = "sis_login_id:" + loginId;
        URI uri = LOGINS_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), firstIdCheck});
        log.debug("{}", (Object)uri);
        List<CanvasLogin> logins = this.doGet(uri, CanvasLogin[].class);
        if (logins == null || logins.isEmpty()) {
            uri = LOGINS_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), secondIdCheck});
            log.debug("{}", (Object)uri);
            logins = this.doGet(uri, CanvasLogin[].class);
        }
        return logins;
    }

    public String createLogin(String accountId, String userId, String loginUniqueId, String password, String sisUserId) {
        URI uri = LOGINS_BASE_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), accountId});
        LoginWrapper loginWrapper = new LoginWrapper();
        PostedUser postedUser = new PostedUser();
        postedUser.setId(userId);
        loginWrapper.setUser(postedUser);
        PostedLogin postedLogin = new PostedLogin(loginUniqueId, password, sisUserId, false);
        loginWrapper.setLogin(postedLogin);
        HttpHeaders headers = new HttpHeaders();
        HttpEntity requestEntity = new HttpEntity((Object)loginWrapper, (MultiValueMap)headers);
        try {
            CanvasLogin createdLogin = (CanvasLogin)this.restTemplate.postForObject(uri, (Object)requestEntity, CanvasLogin.class);
            return createdLogin != null ? createdLogin.getId() : null;
        }
        catch (HttpClientErrorException hcee) {
            log.error("Request to Canvas was not successful. Response code: " + hcee.getStatusCode() + ", reason: " + hcee.getStatusText() + ", entity: " + hcee.getResponseBodyAsString(), (Throwable)hcee);
            return null;
        }
    }

    public String createUser(String accountId, String firstName, String lastName, String loginUniqueId, String sisUserId, String email, String pronouns) {
        JsonUser jsonUser = new JsonUser();
        PostedUser postedUser = new PostedUser();
        postedUser.setName(firstName + " " + lastName);
        postedUser.setShortName(firstName + " " + lastName);
        postedUser.setSortableName(lastName + ", " + firstName);
        if (email != null) {
            CommunicationChannel cc = new CommunicationChannel();
            cc.setType("email");
            cc.setAddress(email);
            cc.setSkipConfirmation(true);
            jsonUser.setCommunicationChannel(cc);
        }
        postedUser.setPronouns(pronouns);
        postedUser.setTermsOfUse("true");
        postedUser.setSkipRegistration(true);
        jsonUser.setUser(postedUser);
        PostedLogin pseudonym = new PostedLogin(loginUniqueId, null, sisUserId, false);
        jsonUser.setPseudonym(pseudonym);
        return this.createUser(accountId, jsonUser);
    }

    public String createUserWithUser(String accountId, User user) {
        JsonUser jsonUser = new JsonUser();
        PostedUser postedUser = new PostedUser();
        postedUser.setName(user.getName());
        postedUser.setShortName(user.getShortName());
        postedUser.setSortableName(user.getSortableName());
        postedUser.setTermsOfUse("true");
        jsonUser.setUser(postedUser);
        PostedLogin pseudonym = new PostedLogin(user.getLoginId(), null, user.getLoginId(), false);
        jsonUser.setPseudonym(pseudonym);
        return this.createUser(accountId, jsonUser);
    }

    private String createUser(String accountId, JsonUser jsonUser) {
        URI uri = ACCOUNTS_USERS_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), accountId});
        HttpHeaders headers = new HttpHeaders();
        HttpEntity requestEntity = new HttpEntity((Object)jsonUser, (MultiValueMap)headers);
        try {
            User createdUser = (User)this.restTemplate.postForObject(uri, (Object)requestEntity, User.class);
            return createdUser != null ? createdUser.getId() : null;
        }
        catch (HttpClientErrorException hcee) {
            log.error("Request to Canvas was not successful. Response code: " + hcee.getStatusCode() + ", reason: " + hcee.getStatusText() + ", entity: " + hcee.getResponseBodyAsString());
            return null;
        }
    }

    public User getUserBySisId(String sis_user_id) {
        return this.getUser("sis_user_id", sis_user_id);
    }

    public User getUserBySisLoginId(String sis_login_id) {
        return this.getUser("sis_login_id", sis_login_id);
    }

    public User getUserByCanvasId(String canvasId) {
        if (canvasId == null || canvasId.trim().length() == 0) {
            return null;
        }
        return this.getUser(null, canvasId);
    }

    private User getUser(String field, String value) {
        String userPath = this.buildAlternateId(value, field);
        URI uri = USERS_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), userPath});
        try {
            return (User)this.restTemplate.getForObject(uri, User.class);
        }
        catch (HttpClientErrorException hcee) {
            log.error("Request to Canvas was not successful. Response code: " + hcee.getStatusCode() + ", reason: " + hcee.getStatusText() + ", entity: " + hcee.getResponseBodyAsString());
            return null;
        }
    }

    public List<License> getLicenses(String sisLoginId) {
        String loginPath = "sis_login_id:" + sisLoginId;
        URI uri = LICENSE_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), loginPath});
        return this.doGet(uri, License[].class);
    }

    public Profile getProfile(String sisUserId) {
        String profilePath = "sis_user_id:" + sisUserId;
        URI uri = PROFILE_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), profilePath});
        try {
            return (Profile)this.restTemplate.getForObject(uri, Profile.class);
        }
        catch (HttpClientErrorException hcee) {
            log.error("Request to Canvas was not successful. Response code: " + hcee.getStatusCode() + ", reason: " + hcee.getStatusText() + ", entity: " + hcee.getResponseBodyAsString());
            return null;
        }
    }

    public CanvasLogin getLogin(String sisUserId) {
        List<CanvasLogin> logins = this.getLogins(sisUserId);
        if (logins != null && logins.size() > 0) {
            for (CanvasLogin login : logins) {
                if (!sisUserId.equals(login.getSisUserId())) continue;
                return login;
            }
        }
        return null;
    }

    public List<CanvasLogin> getLogins(String sisUserId) {
        String loginPath = "sis_user_id:" + sisUserId;
        URI uri = LOGINS_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), loginPath});
        return this.doGet(uri, CanvasLogin[].class);
    }

    public User updateUserNameDetails(String existingCanvasUserId, NameWrapper nameWrapper) {
        URI uri = USERS_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), existingCanvasUserId});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("user[name]", new Object[]{nameWrapper.getName()});
        builder.queryParam("user[short_name]", new Object[]{nameWrapper.getShortName()});
        builder.queryParam("user[sortable_name]", new Object[]{nameWrapper.getSortableName()});
        ResponseEntity response = this.restTemplate.exchange(builder.build().toUri(), HttpMethod.PUT, null, User.class);
        return (User)response.getBody();
    }

    public void updateEmail(String canvasUserId, String email) {
        URI uri = USERS_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), canvasUserId});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("user[email]", new Object[]{email});
        this.restTemplate.exchange(builder.build().toUri(), HttpMethod.PUT, null, User.class);
    }

    public CanvasLogin updateLogin(String accountId, String loginId, String newLoginUniqueId) {
        URI uri = LOGIN_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), accountId, loginId});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("login[unique_id]", new Object[]{newLoginUniqueId});
        ResponseEntity response = this.restTemplate.exchange(builder.build().toUri(), HttpMethod.PUT, null, CanvasLogin.class);
        return (CanvasLogin)response.getBody();
    }

    public User updatePronouns(String canvasUserId, String pronouns) {
        URI uri = USERS_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), canvasUserId});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("user[pronouns]", new Object[]{pronouns});
        ResponseEntity response = this.restTemplate.exchange(builder.build().toUri(), HttpMethod.PUT, null, User.class);
        return (User)response.getBody();
    }

    public static class NameWrapper
    implements Serializable {
        private String name;
        private String shortName;
        private String sortableName;

        public String getName() {
            return this.name;
        }

        public String getShortName() {
            return this.shortName;
        }

        public String getSortableName() {
            return this.sortableName;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setShortName(String shortName) {
            this.shortName = shortName;
        }

        public void setSortableName(String sortableName) {
            this.sortableName = sortableName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NameWrapper)) {
                return false;
            }
            NameWrapper other = (NameWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$shortName = this.getShortName();
            String other$shortName = other.getShortName();
            if (this$shortName == null ? other$shortName != null : !this$shortName.equals(other$shortName)) {
                return false;
            }
            String this$sortableName = this.getSortableName();
            String other$sortableName = other.getSortableName();
            return !(this$sortableName == null ? other$sortableName != null : !this$sortableName.equals(other$sortableName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof NameWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $shortName = this.getShortName();
            result = result * 59 + ($shortName == null ? 43 : $shortName.hashCode());
            String $sortableName = this.getSortableName();
            result = result * 59 + ($sortableName == null ? 43 : $sortableName.hashCode());
            return result;
        }

        public String toString() {
            return "UserService.NameWrapper(name=" + this.getName() + ", shortName=" + this.getShortName() + ", sortableName=" + this.getSortableName() + ")";
        }
    }
}

