/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.canvas.utils;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.glassfish.jersey.message.internal.JerseyLink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;

public class LinkHeaderParser {
    private static final Logger log = LoggerFactory.getLogger(LinkHeaderParser.class);
    private static final String LINK_DELIM = ",";
    private HttpHeaders headers;
    private Map<LINK_KEY, String> headerMap = new HashMap<LINK_KEY, String>();

    public LinkHeaderParser(HttpHeaders headers) {
        this.headers = headers;
        this.parse();
    }

    private void parse() {
        String linkHeaderValue = this.headers.getFirst("Link");
        if (linkHeaderValue != null) {
            List<String> links = Arrays.asList(linkHeaderValue.split(LINK_DELIM));
            for (String linkVal : links) {
                String trimmedLink = linkVal.trim();
                if (trimmedLink.isEmpty()) continue;
                JerseyLink.Builder b = new JerseyLink.Builder();
                JerseyLink link = b.link(trimmedLink).build(new Object[0]);
                this.headerMap.put(LINK_KEY.valueOf(link.getRel().toUpperCase()), link.getUri().toString());
            }
        }
    }

    private Object extractTypeOfRelation(String linkRelation) {
        int positionOfEquals = linkRelation.indexOf(61);
        return linkRelation.substring(positionOfEquals + 2, linkRelation.length() - 1).trim();
    }

    public boolean hasLinkHeader() {
        return this.headerMap.size() > 0;
    }

    public String getFirst() {
        return this.headerMap.get((Object)LINK_KEY.FIRST);
    }

    public String getNext() {
        return this.headerMap.get((Object)LINK_KEY.NEXT);
    }

    public String getLast() {
        return this.headerMap.get((Object)LINK_KEY.LAST);
    }

    public String getPrevious() {
        return this.headerMap.get((Object)LINK_KEY.PREV);
    }

    public String getCurrent() {
        return this.headerMap.get((Object)LINK_KEY.CURRENT);
    }

    public String debug(String currentUrl) {
        String lastLink = this.getLast();
        String lastPage = this.getPageForUrl(lastLink);
        String currentPage = this.getPageForUrl(currentUrl);
        return "Page " + currentPage + " of " + lastPage;
    }

    private String getPageForUrl(String url) {
        List queryParams = URLEncodedUtils.parse((String)url, (Charset)Charset.defaultCharset());
        Map<String, String> paramMap = queryParams.stream().collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue));
        return paramMap.get("page");
    }

    private static enum LINK_KEY {
        FIRST,
        PREV,
        NEXT,
        LAST,
        CURRENT;

    }
}

