/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.canvas.utils.resttemplate;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class LoggingRequestInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LoggingRequestInterceptor.class);
    private static final int REQUEST_LOGGING_LIMIT = 1000;

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        this.traceRequest(request, body);
        ClientHttpResponse response = execution.execute(request, body);
        this.traceResponse(response);
        return response;
    }

    private void traceRequest(HttpRequest request, byte[] body) throws IOException {
        byte[] requestBody;
        String AUTHORIZATION_HEADER_NAME = "AUTHORIZATION";
        log.debug("*** Request Start ***");
        log.debug("URI         : " + request.getURI());
        log.debug("Method      : " + request.getMethod());
        log.debug("Headers     : ");
        HttpHeaders httpHeaders = request.getHeaders();
        Set headers = httpHeaders.entrySet();
        for (Map.Entry header : headers) {
            String headerName = (String)header.getKey();
            for (String headerValue : (List)header.getValue()) {
                if (headerName.toLowerCase().equalsIgnoreCase("AUTHORIZATION")) {
                    headerValue = "*****";
                }
                log.debug("  " + headerName + " : " + headerValue);
            }
        }
        if (body.length > 1000) {
            requestBody = Arrays.copyOfRange(body, 0, 1000);
            log.debug("***** THIS REQUEST LOG HAS BEEN TRUNCATED DUE TO SIZE LIMITATIONS *****");
        } else {
            requestBody = body;
        }
        log.debug("Request body: " + new String(requestBody, "UTF-8"));
        log.debug("*** Request End ***");
    }

    private void traceResponse(ClientHttpResponse response) throws IOException {
        StringBuilder inputStringBuilder = new StringBuilder();
        HttpStatus status = response.getStatusCode();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getBody(), "UTF-8"));
        String line = bufferedReader.readLine();
        while (line != null) {
            inputStringBuilder.append(line);
            inputStringBuilder.append('\n');
            line = bufferedReader.readLine();
        }
        log.debug("============================response begin==========================================");
        log.debug("Status code  : " + status);
        log.debug("Status text  : " + response.getStatusText());
        log.debug("Headers      : " + response.getHeaders());
        log.debug("Response body: " + inputStringBuilder.toString());
        log.debug("=======================response end=================================================");
    }
}

