/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.hlt.alnc;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.jhu.hlt.alnc.ALNCArticleBean;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.stream.Stream;

public class ALNCFileConverter
implements AutoCloseable {
    private static final ObjectMapper om = new ObjectMapper();
    private final InputStream is;
    private final InputStreamReader isr;
    private final BufferedReader br;

    public ALNCFileConverter(InputStream is) {
        this.is = is;
        this.isr = new InputStreamReader(is, StandardCharsets.UTF_8);
        this.br = new BufferedReader(this.isr, 262144);
    }

    public ALNCFileConverter(Path path) throws IOException {
        this(Files.newInputStream(path, new OpenOption[0]));
    }

    public Stream<ALNCArticleBean> stream() throws IOException {
        return ((Stream)this.br.lines().sequential()).map(l -> {
            try {
                return (ALNCArticleBean)om.readValue(l, ALNCArticleBean.class);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.br.close();
        this.isr.close();
        this.is.close();
    }
}

