/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.hlt.concrete.ingesters.alnc;

import edu.jhu.hlt.alnc.ALNCArticleBean;
import edu.jhu.hlt.alnc.ALNCFileConverter;
import edu.jhu.hlt.concrete.Communication;
import edu.jhu.hlt.concrete.ingesters.alnc.CommunicationizableALNCArticle;
import edu.jhu.hlt.concrete.ingesters.base.IngestException;
import edu.jhu.hlt.concrete.ingesters.base.stream.IteratorBasedStreamIngester;
import edu.jhu.hlt.concrete.util.ConcreteException;
import edu.jhu.hlt.concrete.util.Timing;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;

public class ALNCIngester
implements IteratorBasedStreamIngester,
AutoCloseable {
    private final long ts = Timing.currentLocalTime();
    private final Path path;
    private final ALNCFileConverter conv;

    public ALNCIngester(Path path) throws IngestException {
        this.path = path;
        try {
            Optional<String> inferredType = Optional.ofNullable(Files.probeContentType(this.path));
            String ft = inferredType.orElse("unk");
            this.conv = ft.contains("bzip") ? new ALNCFileConverter((InputStream)new BZip2CompressorInputStream(Files.newInputStream(this.path, new OpenOption[0]))) : new ALNCFileConverter(Files.newInputStream(this.path, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new IngestException((Throwable)e);
        }
    }

    public String getKind() {
        return "news";
    }

    public long getTimestamp() {
        return this.ts;
    }

    public String getToolName() {
        return ALNCIngester.class.getSimpleName();
    }

    public List<String> getToolNotes() {
        ArrayList<String> notes = new ArrayList<String>();
        notes.add("Original file path: " + this.path.toString());
        return notes;
    }

    public String getToolVersion() {
        return "4.11.2.1";
    }

    public Iterator<Communication> iterator() throws IngestException {
        try {
            return new ALNCCommunicationIterator(this.conv);
        }
        catch (IOException e) {
            throw new IngestException((Throwable)e);
        }
    }

    @Override
    public void close() throws IngestException {
        try {
            this.conv.close();
        }
        catch (IOException e) {
            throw new IngestException((Throwable)e);
        }
    }

    private static class ALNCCommunicationIterator
    implements Iterator<Communication> {
        private final Iterator<ALNCArticleBean> iterator;

        private ALNCCommunicationIterator(ALNCFileConverter conv) throws IOException {
            this.iterator = conv.stream().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Communication next() {
            try {
                return new CommunicationizableALNCArticle(this.iterator.next()).toCommunication();
            }
            catch (ConcreteException e) {
                throw new RuntimeException("Error mapping documents from ALNC to Concrete.", e);
            }
        }
    }
}

