/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.hlt.concrete.ingesters.alnc;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParametersDelegate;
import edu.jhu.hlt.acute.archivers.Archivable;
import edu.jhu.hlt.acute.archivers.tar.TarArchiver;
import edu.jhu.hlt.concrete.Communication;
import edu.jhu.hlt.concrete.ingesters.alnc.ALNCIngester;
import edu.jhu.hlt.concrete.ingesters.base.IngestException;
import edu.jhu.hlt.concrete.ingesters.base.IngesterParameterDelegate;
import edu.jhu.hlt.concrete.serialization.archiver.ArchivableCommunication;
import edu.jhu.hlt.utilt.ex.LoggedUncaughtExceptionHandler;
import edu.jhu.hlt.utilt.io.ExistingNonDirectoryFile;
import edu.jhu.hlt.utilt.io.NotFileException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ALNCIngesterRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ALNCIngesterRunner.class);
    @ParametersDelegate
    private IngesterParameterDelegate delegate = new IngesterParameterDelegate();

    public static void main(String ... args) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new LoggedUncaughtExceptionHandler());
        ALNCIngesterRunner run = new ALNCIngesterRunner();
        JCommander jc = new JCommander((Object)run, args);
        jc.setProgramName(ALNCIngesterRunner.class.getSimpleName());
        if (run.delegate.help) {
            jc.usage();
        }
        try {
            Path outpath = Paths.get(run.delegate.outputPath, new String[0]);
            IngesterParameterDelegate.prepare((Path)outpath);
            for (String pstr : run.delegate.paths) {
                LOGGER.debug("Running on file: {}", (Object)pstr);
                Path p = Paths.get(pstr, new String[0]);
                new ExistingNonDirectoryFile(p);
                Path outWithExt = outpath.resolve(p.getFileName() + ".tar.gz");
                if (Files.exists(outWithExt, new LinkOption[0])) {
                    if (!run.delegate.overwrite) {
                        LOGGER.info("File: {} exists and overwrite disabled. Not running.", (Object)outWithExt.toString());
                        continue;
                    }
                    Files.delete(outWithExt);
                }
                try {
                    ALNCIngester ing = new ALNCIngester(p);
                    Throwable throwable = null;
                    try {
                        OutputStream os = Files.newOutputStream(outWithExt, new OpenOption[0]);
                        Throwable throwable2 = null;
                        try {
                            GzipCompressorOutputStream gout = new GzipCompressorOutputStream(os);
                            Throwable throwable3 = null;
                            try {
                                TarArchiver arch = new TarArchiver(gout);
                                Throwable throwable4 = null;
                                try {
                                    Iterator<Communication> iter = ing.iterator();
                                    while (iter.hasNext()) {
                                        Communication c = iter.next();
                                        LOGGER.debug("Got comm: {}", (Object)c.getId());
                                        arch.addEntry((Archivable)new ArchivableCommunication(c));
                                    }
                                }
                                catch (Throwable throwable5) {
                                    throwable4 = throwable5;
                                    throw throwable5;
                                }
                                finally {
                                    if (arch == null) continue;
                                    if (throwable4 != null) {
                                        try {
                                            arch.close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable4.addSuppressed(throwable6);
                                        }
                                        continue;
                                    }
                                    arch.close();
                                }
                            }
                            catch (Throwable throwable7) {
                                throwable3 = throwable7;
                                throw throwable7;
                            }
                            finally {
                                if (gout == null) continue;
                                if (throwable3 != null) {
                                    try {
                                        gout.close();
                                    }
                                    catch (Throwable throwable8) {
                                        throwable3.addSuppressed(throwable8);
                                    }
                                    continue;
                                }
                                gout.close();
                            }
                        }
                        catch (Throwable throwable9) {
                            throwable2 = throwable9;
                            throw throwable9;
                        }
                        finally {
                            if (os == null) continue;
                            if (throwable2 != null) {
                                try {
                                    os.close();
                                }
                                catch (Throwable throwable10) {
                                    throwable2.addSuppressed(throwable10);
                                }
                                continue;
                            }
                            os.close();
                        }
                    }
                    catch (Throwable throwable11) {
                        throwable = throwable11;
                        throw throwable11;
                    }
                    finally {
                        if (ing == null) continue;
                        if (throwable != null) {
                            try {
                                ing.close();
                            }
                            catch (Throwable throwable12) {
                                throwable.addSuppressed(throwable12);
                            }
                            continue;
                        }
                        ing.close();
                    }
                }
                catch (IngestException e) {
                    LOGGER.error("Caught exception processing path: " + pstr, (Throwable)e);
                }
            }
        }
        catch (NotFileException | IOException e) {
            LOGGER.error("Caught exception processing.", e);
        }
    }
}

