/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.hlt.concrete.ingesters.alnc;

import edu.jhu.hlt.alnc.ALNCArticleBean;
import edu.jhu.hlt.concrete.AnnotationMetadata;
import edu.jhu.hlt.concrete.Communication;
import edu.jhu.hlt.concrete.ingesters.alnc.ALNCIngester;
import edu.jhu.hlt.concrete.ingesters.base.communications.Communicationizable;
import edu.jhu.hlt.concrete.metadata.tools.SafeTooledAnnotationMetadata;
import edu.jhu.hlt.concrete.metadata.tools.TooledMetadataConverter;
import edu.jhu.hlt.concrete.util.ConcreteException;
import edu.jhu.hlt.concrete.util.Timing;
import edu.jhu.hlt.concrete.uuid.AnalyticUUIDGeneratorFactory;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class CommunicationizableALNCArticle
implements Communicationizable,
SafeTooledAnnotationMetadata {
    private final long ts = Timing.currentLocalTime();
    private final ALNCArticleBean bean;
    private static final DateTimeFormatter alncDateFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");

    public CommunicationizableALNCArticle(ALNCArticleBean bean) {
        this.bean = bean;
    }

    public long getTimestamp() {
        return this.ts;
    }

    public String getToolName() {
        return ALNCIngester.class.getName();
    }

    public List<String> getToolNotes() {
        ArrayList<String> notes = new ArrayList<String>();
        notes.add("State: " + this.bean.getState());
        notes.add("City: " + this.bean.getCity());
        notes.add("Domain: " + this.bean.getDomain());
        notes.add("Article number: " + this.bean.getArticleNumber());
        return notes;
    }

    public String getToolVersion() {
        return "4.11.2.1";
    }

    public Communication toCommunication() throws ConcreteException {
        Communication c = new Communication();
        AnalyticUUIDGeneratorFactory f = new AnalyticUUIDGeneratorFactory();
        AnalyticUUIDGeneratorFactory.AnalyticUUIDGenerator g = f.create();
        c.setUuid(g.next());
        c.setId(this.bean.extractId());
        c.setText(this.bean.getContent());
        AnnotationMetadata md = TooledMetadataConverter.convert((SafeTooledAnnotationMetadata)this);
        c.setMetadata(md);
        long millis = alncDateFormatter.parseMillis(this.bean.getDate());
        c.setStartTime(millis / 1000L);
        c.setType("news");
        return c;
    }
}

