/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.clients;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.kit.datamanager.entities.repo.DataResource;
import edu.kit.datamanager.util.ControllerUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class SimpleServiceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleServiceClient.class);
    private RestTemplate restTemplate = new RestTemplate();
    private final String resourceBaseUrl;
    private String resourcePath = null;
    private String bearerToken = null;
    private HttpHeaders headers;
    private Map<String, String> requestedResponseHeaders = null;
    MultiValueMap<String, Object> body = new LinkedMultiValueMap();
    MultiValueMap<String, String> queryParams = new LinkedMultiValueMap();

    SimpleServiceClient(String resourceBaseUrl) {
        this.resourceBaseUrl = resourceBaseUrl;
        this.headers = new HttpHeaders();
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public static SimpleServiceClient create(String baseUrl) {
        SimpleServiceClient client = new SimpleServiceClient(baseUrl);
        return client;
    }

    public SimpleServiceClient withBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
        if (bearerToken != null) {
            return this.withHeader("Authorization", "Bearer " + bearerToken);
        }
        this.headers.remove((Object)"Authorization");
        return this;
    }

    public SimpleServiceClient withHeader(String field, String value) {
        this.headers.add(field, value);
        return this;
    }

    public SimpleServiceClient accept(MediaType ... mediaType) {
        this.headers.setAccept(Arrays.asList(mediaType));
        return this;
    }

    public SimpleServiceClient collectResponseHeader(Map<String, String> container) {
        this.requestedResponseHeaders = container;
        return this;
    }

    public SimpleServiceClient withContentType(MediaType contentType) {
        this.headers.setContentType(contentType);
        return this;
    }

    public SimpleServiceClient withResourcePath(String resourcePath) {
        LOGGER.trace("Creating SingleResourceAccessClient with resourcePath {}.", (Object)resourcePath);
        this.resourcePath = resourcePath;
        return this;
    }

    public SimpleServiceClient withFormParam(String name, Object object) throws IOException {
        if (name == null || object == null) {
            throw new IllegalArgumentException("Form element key and value must not be null.");
        }
        if (object instanceof File) {
            this.body.add((Object)name, (Object)new FileSystemResource((File)object));
        } else if (object instanceof InputStream) {
            this.body.add((Object)name, (Object)new ByteArrayResource(IOUtils.toByteArray((InputStream)((InputStream)object))){

                public String getFilename() {
                    return "stream#" + UUID.randomUUID().toString();
                }
            });
        } else {
            String metadataString = new ObjectMapper().writeValueAsString(object);
            LOGGER.trace("Adding argument from JSON document {}.", (Object)metadataString);
            this.body.add((Object)name, (Object)new ByteArrayResource(metadataString.getBytes()){

                public String getFilename() {
                    return "metadata#" + UUID.randomUUID().toString() + ".json";
                }
            });
        }
        return this;
    }

    public SimpleServiceClient withQueryParam(String name, String value) {
        this.queryParams.add((Object)name, (Object)value);
        return this;
    }

    public <C> C getResource(Class<C> responseType) {
        LOGGER.trace("Calling getResource().");
        String destinationUri = this.resourceBaseUrl + (this.resourcePath != null ? this.resourcePath : "");
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)destinationUri).queryParams(this.queryParams);
        LOGGER.trace("Obtaining resource from resource URI {}.", (Object)uriBuilder.toUriString());
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.GET, new HttpEntity((MultiValueMap)this.headers), responseType, new Object[0]);
        this.collectResponseHeaders(response.getHeaders());
        LOGGER.trace("Request returned with status {}. Returning response body.", (Object)response.getStatusCodeValue());
        return (C)response.getBody();
    }

    public <C> ResultPage<C> getResources(Class<C[]> responseType) {
        LOGGER.trace("Calling getResource().");
        String destinationUri = this.resourceBaseUrl + (this.resourcePath != null ? this.resourcePath : "");
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)destinationUri).queryParams(this.queryParams);
        LOGGER.trace("Obtaining resource from resource URI {}.", (Object)uriBuilder.toUriString());
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.GET, new HttpEntity((MultiValueMap)this.headers), responseType, new Object[0]);
        LOGGER.trace("Request returned with status {}. Returning response body.", (Object)response.getStatusCodeValue());
        ControllerUtils.ContentRange contentRange = ControllerUtils.parseContentRangeHeader(response.getHeaders().getFirst("Content-Range"));
        this.collectResponseHeaders(response.getHeaders());
        return new ResultPage<Object>((Object[])response.getBody(), contentRange);
    }

    public <C> ResultPage<C> findResources(C resource, Class<C[]> responseType) {
        LOGGER.trace("Calling getResource().");
        String destinationUri = this.resourceBaseUrl + "search";
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)destinationUri).queryParams(this.queryParams);
        LOGGER.trace("Obtaining resource from resource URI {}.", (Object)uriBuilder.toUriString());
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.POST, new HttpEntity(resource, (MultiValueMap)this.headers), responseType, new Object[0]);
        LOGGER.trace("Request returned with status {}. Returning response body.", (Object)response.getStatusCodeValue());
        ControllerUtils.ContentRange contentRange = ControllerUtils.parseContentRangeHeader(response.getHeaders().getFirst("Content-Range"));
        this.collectResponseHeaders(response.getHeaders());
        return new ResultPage<Object>((Object[])response.getBody(), contentRange);
    }

    public int getResource(OutputStream outputStream) {
        String sourceUri = this.resourceBaseUrl + (this.resourcePath != null ? this.resourcePath : "");
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)sourceUri).queryParams(this.queryParams);
        LOGGER.trace("Downloading content from source URI {}.", (Object)uriBuilder.toUriString());
        RequestCallback requestCallback = request -> {
            Set entries = this.headers.entrySet();
            entries.forEach(entry -> request.getHeaders().addAll((String)entry.getKey(), (List)entry.getValue()));
        };
        ResponseExtractor responseExtractor = response -> {
            IOUtils.copy((InputStream)response.getBody(), (OutputStream)outputStream);
            return response;
        };
        ClientHttpResponse response2 = (ClientHttpResponse)this.restTemplate.execute(uriBuilder.toUriString(), HttpMethod.GET, requestCallback, responseExtractor, new Object[0]);
        int status = -1;
        try {
            status = response2.getRawStatusCode();
            LOGGER.trace("Download returned with status {}.", (Object)status);
            this.collectResponseHeaders(response2.getHeaders());
        }
        catch (IOException ex) {
            LOGGER.error("Failed to extract raw status from response.", (Throwable)ex);
        }
        return status;
    }

    public <C> C postResource(C resource, Class<C> responseType) {
        LOGGER.trace("Calling createResource(#DataResource).");
        String destinationUri = this.resourceBaseUrl + (this.resourcePath != null ? this.resourcePath : "");
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)destinationUri).queryParams(this.queryParams);
        LOGGER.trace("Sending POST request for resource.");
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.POST, new HttpEntity(resource, (MultiValueMap)this.headers), responseType, new Object[0]);
        LOGGER.trace("Request returned with status {}. Returning response body.", (Object)response.getStatusCodeValue());
        this.collectResponseHeaders(response.getHeaders());
        return (C)response.getBody();
    }

    public HttpStatus postForm() {
        return this.postForm(MediaType.MULTIPART_FORM_DATA);
    }

    public HttpStatus postForm(MediaType contentType) {
        LOGGER.trace("Adding content type header with value {}.", (Object)contentType);
        this.headers.setContentType(contentType);
        String destinationUri = this.resourceBaseUrl + (this.resourcePath != null ? this.resourcePath : "");
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)destinationUri).queryParams(this.queryParams);
        LOGGER.trace("Uploading content to destination URI {}.", (Object)uriBuilder.toUriString());
        ResponseEntity response = this.restTemplate.postForEntity(uriBuilder.toUriString(), (Object)new HttpEntity(this.body, (MultiValueMap)this.headers), String.class, new Object[0]);
        LOGGER.trace("Upload returned with status {}.", (Object)response.getStatusCodeValue());
        this.collectResponseHeaders(response.getHeaders());
        return response.getStatusCode();
    }

    public <C> C putResource(C resource, Class<C> responseType) {
        LOGGER.trace("Calling updateResource(#DataResource).");
        String destinationUri = this.resourceBaseUrl + (this.resourcePath != null ? this.resourcePath : "");
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)destinationUri).queryParams(this.queryParams);
        LOGGER.trace("Obtaining resource from resource URI {}.", (Object)uriBuilder.toUriString());
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.GET, new HttpEntity((MultiValueMap)this.headers), responseType, new Object[0]);
        LOGGER.trace("Reading ETag from response header.");
        String etag = response.getHeaders().getFirst("ETag");
        LOGGER.trace("Sending PUT request for resource with ETag {}.", (Object)etag);
        this.headers.setIfMatch(etag);
        response = this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.PUT, new HttpEntity(resource, (MultiValueMap)this.headers), responseType, new Object[0]);
        this.collectResponseHeaders(response.getHeaders());
        LOGGER.trace("Request returned with status {}. Returning response body.", (Object)response.getStatusCodeValue());
        return (C)response.getBody();
    }

    public void deleteResource() {
        LOGGER.trace("Calling delete().");
        String destinationUri = this.resourceBaseUrl + (this.resourcePath != null ? this.resourcePath : "");
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)destinationUri).queryParams(this.queryParams);
        LOGGER.trace("Obtaining resource from resource URI {}.", (Object)uriBuilder.toUriString());
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.GET, new HttpEntity((MultiValueMap)this.headers), DataResource.class, new Object[0]);
        LOGGER.trace("Reading ETag from response header.");
        String etag = response.getHeaders().getFirst("ETag");
        LOGGER.trace("Obtained ETag value {}.", (Object)etag);
        LOGGER.trace("Sending DELETE request for resource with ETag {}.", (Object)etag);
        this.headers.setIfMatch(etag);
        response = this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.DELETE, new HttpEntity((MultiValueMap)this.headers), DataResource.class, new Object[0]);
        this.collectResponseHeaders(response.getHeaders());
        LOGGER.trace("Request returned with status {}. No response body expected.", (Object)response.getStatusCodeValue());
    }

    private void collectResponseHeaders(HttpHeaders responseHeaders) {
        if (this.requestedResponseHeaders != null) {
            Set<Map.Entry<String, String>> entries = this.requestedResponseHeaders.entrySet();
            entries.forEach(entry -> this.requestedResponseHeaders.put((String)entry.getKey(), responseHeaders.getFirst((String)entry.getKey())));
        }
    }

    public static void main(String[] args) {
        ResultPage result = SimpleServiceClient.create("http://localhost:8090/api/v1/dataresources1/").getResources(DataResource[].class);
        System.out.println(result.getContentRange());
        for (DataResource r : (DataResource[])result.getResources()) {
            System.out.println(r);
        }
    }

    public static class SortField {
        String fieldName;
        DIR direction;

        public SortField(String fieldName, DIR direction) {
            this.fieldName = fieldName;
            this.direction = direction;
        }

        public String toQueryParam() {
            return this.fieldName + (this.direction != null ? "," + this.direction.toString().toLowerCase() : "");
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public DIR getDirection() {
            return this.direction;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public void setDirection(DIR direction) {
            this.direction = direction;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SortField)) {
                return false;
            }
            SortField other = (SortField)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$fieldName = this.getFieldName();
            String other$fieldName = other.getFieldName();
            if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
                return false;
            }
            DIR this$direction = this.getDirection();
            DIR other$direction = other.getDirection();
            return !(this$direction == null ? other$direction != null : !((Object)((Object)this$direction)).equals((Object)other$direction));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SortField;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fieldName = this.getFieldName();
            result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
            DIR $direction = this.getDirection();
            result = result * 59 + ($direction == null ? 43 : ((Object)((Object)$direction)).hashCode());
            return result;
        }

        public String toString() {
            return "SimpleServiceClient.SortField(fieldName=" + this.getFieldName() + ", direction=" + (Object)((Object)this.getDirection()) + ")";
        }

        public static enum DIR {
            ASC,
            DESC;

        }
    }

    public static class ResultPage<C> {
        ControllerUtils.ContentRange contentRange;
        C[] resources;

        public ResultPage(C[] resources, ControllerUtils.ContentRange range) {
            this.resources = resources;
            this.contentRange = range;
        }

        public ControllerUtils.ContentRange getContentRange() {
            return this.contentRange;
        }

        public C[] getResources() {
            return this.resources;
        }

        public void setContentRange(ControllerUtils.ContentRange contentRange) {
            this.contentRange = contentRange;
        }

        public void setResources(C[] resources) {
            this.resources = resources;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultPage)) {
                return false;
            }
            ResultPage other = (ResultPage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ControllerUtils.ContentRange this$contentRange = this.getContentRange();
            ControllerUtils.ContentRange other$contentRange = other.getContentRange();
            if (this$contentRange == null ? other$contentRange != null : !((Object)this$contentRange).equals(other$contentRange)) {
                return false;
            }
            return Arrays.deepEquals(this.getResources(), other.getResources());
        }

        protected boolean canEqual(Object other) {
            return other instanceof ResultPage;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ControllerUtils.ContentRange $contentRange = this.getContentRange();
            result = result * 59 + ($contentRange == null ? 43 : ((Object)$contentRange).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getResources());
            return result;
        }

        public String toString() {
            return "SimpleServiceClient.ResultPage(contentRange=" + this.getContentRange() + ", resources=" + Arrays.deepToString(this.getResources()) + ")";
        }
    }
}

