/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.clients.impl;

import edu.kit.datamanager.clients.SimpleServiceClient;
import edu.kit.datamanager.entities.repo.ContentInformation;
import edu.kit.datamanager.entities.repo.DataResource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;

public class SimpleRepositoryClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleRepositoryClient.class);
    private final String resourceBaseUrl;
    private final String bearerToken;

    SimpleRepositoryClient(String resourceBaseUrl, String bearerToken) {
        this.resourceBaseUrl = resourceBaseUrl;
        this.bearerToken = bearerToken;
    }

    public static SimpleRepositoryClient create(String resourceBaseUrl) {
        return SimpleRepositoryClient.create(resourceBaseUrl, null);
    }

    public static SimpleRepositoryClient create(String resourceBaseUrl, String bearerToken) {
        return new SimpleRepositoryClient(resourceBaseUrl, bearerToken);
    }

    public DataResource getResource(String resourceId) {
        return SimpleServiceClient.create(this.resourceBaseUrl).withResourcePath(resourceId).accept(MediaType.APPLICATION_JSON).withBearerToken(this.bearerToken).getResource(DataResource.class);
    }

    public SimpleServiceClient.ResultPage<DataResource> getResources(int page, int elementsPerPage, SimpleServiceClient.SortField ... fields) {
        return this.getResources(null, page, elementsPerPage, fields);
    }

    public SimpleServiceClient.ResultPage<DataResource> getResources(DataResource example, int page, int elementsPerPage, SimpleServiceClient.SortField ... fields) {
        SimpleServiceClient client = SimpleServiceClient.create(this.resourceBaseUrl).accept(MediaType.APPLICATION_JSON).withBearerToken(this.bearerToken).withQueryParam("page", Integer.toString(page)).withQueryParam("size", Integer.toString(elementsPerPage));
        if (fields != null) {
            for (SimpleServiceClient.SortField field : fields) {
                client = client.withQueryParam("sort", field.toQueryParam());
            }
        }
        if (example == null) {
            return client.getResources(DataResource[].class);
        }
        return client.findResources(example, DataResource[].class);
    }

    public int getData(String resourceId, String relativePath, OutputStream stream) {
        return SimpleServiceClient.create(this.resourceBaseUrl).withResourcePath(resourceId + "/data/" + relativePath).accept(MediaType.APPLICATION_OCTET_STREAM).withBearerToken(this.bearerToken).getResource(stream);
    }

    public HttpStatus uploadData(String resourceId, String relativePath, InputStream stream, boolean force) throws IOException {
        return this.uploadData(resourceId, relativePath, stream, null, force);
    }

    public HttpStatus uploadData(String resourceId, String relativePath, InputStream stream, ContentInformation metadata, boolean force) throws IOException {
        return SimpleServiceClient.create(this.resourceBaseUrl).withResourcePath(resourceId + "/data/" + relativePath).withBearerToken(this.bearerToken).withQueryParam("force", Boolean.toString(force)).withFormParam("file", stream).withFormParam("metadata", metadata).postForm();
    }

    public HttpStatus uploadData(String resourceId, String relativePath, File file, boolean force) throws IOException {
        return this.uploadData(resourceId, relativePath, file, null, force);
    }

    public HttpStatus uploadData(String resourceId, String relativePath, File file, ContentInformation metadata, boolean force) throws IOException {
        return SimpleServiceClient.create(this.resourceBaseUrl).withResourcePath(resourceId + "/data/" + relativePath).withQueryParam("force", Boolean.toString(force)).withBearerToken(this.bearerToken).withFormParam("file", file).withFormParam("metadata", metadata).postForm();
    }

    public ContentInformation[] getContentInformation(String resourceId, String relativePath) {
        if (relativePath == null || relativePath.endsWith("/")) {
            return SimpleServiceClient.create(this.resourceBaseUrl).withResourcePath(resourceId + "/data/" + relativePath).accept(ContentInformation.CONTENT_INFORMATION_MEDIA_TYPE).withBearerToken(this.bearerToken).getResource(ContentInformation[].class);
        }
        return new ContentInformation[]{SimpleServiceClient.create(this.resourceBaseUrl).withResourcePath(resourceId + "/data/" + relativePath).accept(ContentInformation.CONTENT_INFORMATION_MEDIA_TYPE).withBearerToken(this.bearerToken).getResource(ContentInformation.class)};
    }

    public DataResource createResource(DataResource resource) {
        return SimpleServiceClient.create(this.resourceBaseUrl).withContentType(MediaType.APPLICATION_JSON).accept(MediaType.APPLICATION_JSON).withBearerToken(this.bearerToken).postResource(resource, DataResource.class);
    }

    public DataResource updateResource(DataResource resource) {
        return SimpleServiceClient.create(this.resourceBaseUrl).withContentType(MediaType.APPLICATION_JSON).accept(MediaType.APPLICATION_JSON).withBearerToken(this.bearerToken).withResourcePath(resource.getId()).putResource(resource, DataResource.class);
    }

    public void deleteResource(String resourceId) {
        SimpleServiceClient.create(this.resourceBaseUrl).withResourcePath(resourceId).withContentType(MediaType.APPLICATION_JSON).accept(MediaType.APPLICATION_JSON).withBearerToken(this.bearerToken).deleteResource();
    }
}

