/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.configuration;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RabbitMQConfiguration {
    private final Logger logger = LoggerFactory.getLogger(RabbitMQConfiguration.class);
    @Value(value="${repo.messaging.username:guest}")
    private String username;
    @Value(value="${repo.messaging.password:guest}")
    private String password;
    @Value(value="${repo.messaging.hostname:localhost}")
    private String hostname;
    @Value(value="${repo.messaging.port:5672}")
    private int port;
    @Value(value="${repo.messaging.sender.exchange:repository_events}")
    private String exchange;
    @Value(value="${repo.messaging.enabled:FALSE}")
    private boolean messagingEnabled;

    @Bean
    @ConditionalOnProperty(prefix="repo.messaging", name={"enabled"}, havingValue="true")
    public ConnectionFactory rabbitMQConnectionFactory() {
        this.logger.trace("Connecting to RabbitMQ service at host {} and port {}.", (Object)this.hostname, (Object)this.port);
        CachingConnectionFactory factory = new CachingConnectionFactory(this.hostname, this.port);
        factory.setUsername(this.username);
        factory.setPassword(this.password);
        return factory;
    }

    @Bean
    @ConditionalOnProperty(prefix="repo.messaging", name={"enabled"}, havingValue="true")
    public RabbitTemplate rabbitMQTemplate() {
        this.logger.trace("Get RabbitMQ template");
        return new RabbitTemplate(this.rabbitMQConnectionFactory());
    }

    @Bean
    @ConditionalOnProperty(prefix="repo.messaging", name={"enabled"}, havingValue="true")
    public TopicExchange rabbitMQExchange() {
        this.logger.trace("Get Topic Exchange '{}'", (Object)this.exchange);
        return new TopicExchange(this.exchange);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getExchange() {
        return this.exchange;
    }

    public boolean isMessagingEnabled() {
        return this.messagingEnabled;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setExchange(String exchange) {
        this.exchange = exchange;
    }

    public void setMessagingEnabled(boolean messagingEnabled) {
        this.messagingEnabled = messagingEnabled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RabbitMQConfiguration)) {
            return false;
        }
        RabbitMQConfiguration other = (RabbitMQConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.isMessagingEnabled() != other.isMessagingEnabled()) {
            return false;
        }
        Logger this$logger = this.getLogger();
        Logger other$logger = other.getLogger();
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$exchange = this.getExchange();
        String other$exchange = other.getExchange();
        return !(this$exchange == null ? other$exchange != null : !this$exchange.equals(other$exchange));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RabbitMQConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        result = result * 59 + (this.isMessagingEnabled() ? 79 : 97);
        Logger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $exchange = this.getExchange();
        result = result * 59 + ($exchange == null ? 43 : $exchange.hashCode());
        return result;
    }

    public String toString() {
        return "RabbitMQConfiguration(logger=" + this.getLogger() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", hostname=" + this.getHostname() + ", port=" + this.getPort() + ", exchange=" + this.getExchange() + ", messagingEnabled=" + this.isMessagingEnabled() + ")";
    }
}

