/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.controller.hateoas;

import edu.kit.datamanager.controller.hateoas.event.PaginatedResultsRetrievedEvent;
import edu.kit.datamanager.util.LinkUtil;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

@Component
class PaginatedResultsRetrievedDiscoverabilityListener
implements ApplicationListener<PaginatedResultsRetrievedEvent> {
    private static final String PAGE = "page";

    public final void onApplicationEvent(PaginatedResultsRetrievedEvent ev) {
        Objects.nonNull((Object)ev);
        this.addLinkHeaderOnPagedResourceRetrieval(ev.getUriBuilder(), ev.getResponse(), ev.getClazz(), ev.getSuffix(), ev.getPage(), ev.getTotalPages(), ev.getPageSize());
    }

    final void addLinkHeaderOnPagedResourceRetrieval(UriComponentsBuilder uriBuilder, HttpServletResponse response, Class clazz, String suffix, int page, int totalPages, int pageSize) {
        this.plural(uriBuilder, clazz, suffix);
        StringBuilder linkHeader = new StringBuilder();
        if (this.hasNextPage(page, totalPages)) {
            String uriForNextPage = this.constructNextPageUri(uriBuilder, page, pageSize);
            linkHeader.append(LinkUtil.createLinkHeader(uriForNextPage, "next"));
        }
        if (this.hasPreviousPage(page)) {
            String uriForPrevPage = this.constructPrevPageUri(uriBuilder, page, pageSize);
            this.appendCommaIfNecessary(linkHeader);
            linkHeader.append(LinkUtil.createLinkHeader(uriForPrevPage, "prev"));
        }
        if (this.hasFirstPage(page)) {
            String uriForFirstPage = this.constructFirstPageUri(uriBuilder, pageSize);
            this.appendCommaIfNecessary(linkHeader);
            linkHeader.append(LinkUtil.createLinkHeader(uriForFirstPage, "first"));
        }
        if (this.hasLastPage(page, totalPages)) {
            String uriForLastPage = this.constructLastPageUri(uriBuilder, totalPages, pageSize);
            this.appendCommaIfNecessary(linkHeader);
            linkHeader.append(LinkUtil.createLinkHeader(uriForLastPage, "last"));
        }
        if (linkHeader.length() > 0) {
            response.addHeader("Link", linkHeader.toString());
        }
    }

    final String constructNextPageUri(UriComponentsBuilder uriBuilder, int page, int size) {
        return uriBuilder.replaceQueryParam(PAGE, new Object[]{page + 1}).replaceQueryParam("size", new Object[]{size}).build().encode().toUriString();
    }

    final String constructPrevPageUri(UriComponentsBuilder uriBuilder, int page, int size) {
        return uriBuilder.replaceQueryParam(PAGE, new Object[]{page - 1}).replaceQueryParam("size", new Object[]{size}).build().encode().toUriString();
    }

    final String constructFirstPageUri(UriComponentsBuilder uriBuilder, int size) {
        return uriBuilder.replaceQueryParam(PAGE, new Object[]{0}).replaceQueryParam("size", new Object[]{size}).build().encode().toUriString();
    }

    final String constructLastPageUri(UriComponentsBuilder uriBuilder, int totalPages, int size) {
        return uriBuilder.replaceQueryParam(PAGE, new Object[]{totalPages - 1}).replaceQueryParam("size", new Object[]{size}).build().encode().toUriString();
    }

    final boolean hasNextPage(int page, int totalPages) {
        return page < totalPages - 1;
    }

    final boolean hasPreviousPage(int page) {
        return page > 0;
    }

    final boolean hasFirstPage(int page) {
        return this.hasPreviousPage(page);
    }

    final boolean hasLastPage(int page, int totalPages) {
        return totalPages > 1 && this.hasNextPage(page, totalPages);
    }

    final void appendCommaIfNecessary(StringBuilder linkHeader) {
        if (linkHeader.length() > 0) {
            linkHeader.append(", ");
        }
    }

    protected void plural(UriComponentsBuilder uriBuilder, Class clazz, String suffix) {
        String resourceName = clazz.getSimpleName().toLowerCase() + "s";
        uriBuilder.path("/api/v1/" + resourceName + "/" + (suffix != null ? suffix : ""));
    }
}

