/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.dao;

import edu.kit.datamanager.annotations.Searchable;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.SingularAttribute;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.util.ReflectionUtils;

public class ByExampleSpecification {
    private final EntityManager entityManager;

    public ByExampleSpecification(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public <T> Specification<T> byExample(T example) {
        return this.byExample(this.entityManager, example);
    }

    public <T> Specification<T> byPatternOnStringAttributes(String pattern, Class<T> entityType) {
        return this.byPatternOnStringAttributes(this.entityManager, pattern, entityType);
    }

    private <T> Specification<T> byExample(EntityManager em, T example) {
        Validate.notNull(example, (String)"example must not be null", (Object[])new Object[0]);
        Class<?> type = example.getClass();
        return (Specification & Serializable)(root, query, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            Set types = em.getMetamodel().entity(type).getDeclaredSingularAttributes();
            for (Attribute attr : types) {
                if (attr.getPersistentAttributeType() == Attribute.PersistentAttributeType.MANY_TO_ONE || attr.getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_ONE) continue;
                String fieldName = attr.getName();
                try {
                    Object fieldValue;
                    boolean searchableField;
                    Member javaMember = attr.getJavaMember();
                    if (javaMember instanceof Field) {
                        searchableField = ((Field)javaMember).getAnnotation(Searchable.class) != null;
                    } else {
                        boolean bl = searchableField = ((Method)javaMember).getAnnotation(Searchable.class) != null;
                    }
                    if (!searchableField) continue;
                    if (attr.getJavaType() == String.class) {
                        fieldValue = javaMember instanceof Field ? (String)((Field)javaMember).get(example) : (String)ReflectionUtils.invokeMethod((Method)((Method)javaMember), (Object)example);
                        if (!StringUtils.isNotEmpty((CharSequence)fieldValue)) continue;
                        SingularAttribute stringAttr = em.getMetamodel().entity(type).getDeclaredSingularAttribute(fieldName, String.class);
                        predicates.add(builder.like((Expression)root.get(stringAttr), ByExampleSpecification.pattern((String)fieldValue)));
                        continue;
                    }
                    fieldValue = javaMember instanceof Field ? ((Field)javaMember).get(example) : (String)ReflectionUtils.invokeMethod((Method)((Method)javaMember), (Object)example);
                    if (fieldValue == null) continue;
                    SingularAttribute anyAttr = em.getMetamodel().entity(type).getDeclaredSingularAttribute(fieldName, fieldValue.getClass());
                    predicates.add(builder.equal((Expression)root.get(anyAttr), fieldValue));
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new IllegalStateException("Cannot create specification, IllegalAccessException or IllegalArgumentException occured.", e);
                }
            }
            if (predicates.size() > 0) {
                return builder.and(predicates.toArray(new Predicate[predicates.size()]));
            }
            return builder.conjunction();
        };
    }

    private <T> Specification<T> byPatternOnStringAttributes(EntityManager em, String pattern, Class<T> type) {
        return (Specification & Serializable)(root, query, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            Set types = em.getMetamodel().entity(type).getDeclaredSingularAttributes();
            for (Attribute attr : types) {
                if (attr.getPersistentAttributeType() == Attribute.PersistentAttributeType.MANY_TO_ONE || attr.getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_ONE) continue;
                String fieldName = attr.getName();
                try {
                    if (attr.getJavaType() != String.class || !StringUtils.isNotEmpty((CharSequence)pattern)) continue;
                    SingularAttribute stringAttr = em.getMetamodel().entity(type).getDeclaredSingularAttribute(fieldName, String.class);
                    predicates.add(builder.like((Expression)root.get(stringAttr), ByExampleSpecification.pattern(pattern)));
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to add predicate for attribute " + fieldName + " for unknown reasons.", e);
                }
            }
            if (predicates.size() > 0) {
                return builder.or(predicates.toArray(new Predicate[predicates.size()]));
            }
            return builder.conjunction();
        };
    }

    private static String pattern(String str) {
        return "%" + str + "%";
    }
}

