/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.entities;

public class ContentElement {
    private String resourceId;
    private String relativePath;
    private String fileVersion;
    private long contentLength;
    private String contentUri;
    private String checksum;
    private String repositoryLocation;
    private String versioningService;

    private ContentElement(String resourceId, String relativePath, String contentUri, String version, String versioningService, String checksum, String repositoryLocation, Long contentLength) {
        this.resourceId = resourceId;
        this.relativePath = relativePath;
        this.contentUri = contentUri;
        this.fileVersion = version;
        this.versioningService = versioningService;
        this.checksum = checksum;
        this.repositoryLocation = repositoryLocation;
        this.contentLength = contentLength;
    }

    public static ContentElement createContentElement(String resourceId, String relativePath, String contentUri, String fileVersion, String versioningService, String checksum, String repositoryLocation, Long contentLength) {
        return new ContentElement(resourceId, relativePath, contentUri, fileVersion, versioningService, checksum, repositoryLocation, contentLength);
    }

    public static ContentElement createContentElement(String resourceId, String relativePath, String fileVersion, String versioningService, String checksum, String repositoryLocation, Long contentLength) {
        return new ContentElement(resourceId, relativePath, null, fileVersion, versioningService, checksum, repositoryLocation, contentLength);
    }

    public static ContentElement createContentElement(String resourceId, String relativePath, String fileVersion, String versioningService, String repositoryLocation, Long contentLength) {
        return new ContentElement(resourceId, relativePath, null, fileVersion, versioningService, null, repositoryLocation, contentLength);
    }

    public static ContentElement createContentElement(String resourceId, String relativePath, String fileVersion, String versioningService) {
        return new ContentElement(resourceId, relativePath, null, fileVersion, versioningService, null, null, 0L);
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public String getFileVersion() {
        return this.fileVersion;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getContentUri() {
        return this.contentUri;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public String getRepositoryLocation() {
        return this.repositoryLocation;
    }

    public String getVersioningService() {
        return this.versioningService;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    public void setFileVersion(String fileVersion) {
        this.fileVersion = fileVersion;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    public void setContentUri(String contentUri) {
        this.contentUri = contentUri;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public void setRepositoryLocation(String repositoryLocation) {
        this.repositoryLocation = repositoryLocation;
    }

    public void setVersioningService(String versioningService) {
        this.versioningService = versioningService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContentElement)) {
            return false;
        }
        ContentElement other = (ContentElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContentLength() != other.getContentLength()) {
            return false;
        }
        String this$resourceId = this.getResourceId();
        String other$resourceId = other.getResourceId();
        if (this$resourceId == null ? other$resourceId != null : !this$resourceId.equals(other$resourceId)) {
            return false;
        }
        String this$relativePath = this.getRelativePath();
        String other$relativePath = other.getRelativePath();
        if (this$relativePath == null ? other$relativePath != null : !this$relativePath.equals(other$relativePath)) {
            return false;
        }
        String this$fileVersion = this.getFileVersion();
        String other$fileVersion = other.getFileVersion();
        if (this$fileVersion == null ? other$fileVersion != null : !this$fileVersion.equals(other$fileVersion)) {
            return false;
        }
        String this$contentUri = this.getContentUri();
        String other$contentUri = other.getContentUri();
        if (this$contentUri == null ? other$contentUri != null : !this$contentUri.equals(other$contentUri)) {
            return false;
        }
        String this$checksum = this.getChecksum();
        String other$checksum = other.getChecksum();
        if (this$checksum == null ? other$checksum != null : !this$checksum.equals(other$checksum)) {
            return false;
        }
        String this$repositoryLocation = this.getRepositoryLocation();
        String other$repositoryLocation = other.getRepositoryLocation();
        if (this$repositoryLocation == null ? other$repositoryLocation != null : !this$repositoryLocation.equals(other$repositoryLocation)) {
            return false;
        }
        String this$versioningService = this.getVersioningService();
        String other$versioningService = other.getVersioningService();
        return !(this$versioningService == null ? other$versioningService != null : !this$versioningService.equals(other$versioningService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContentElement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $contentLength = this.getContentLength();
        result = result * 59 + (int)($contentLength >>> 32 ^ $contentLength);
        String $resourceId = this.getResourceId();
        result = result * 59 + ($resourceId == null ? 43 : $resourceId.hashCode());
        String $relativePath = this.getRelativePath();
        result = result * 59 + ($relativePath == null ? 43 : $relativePath.hashCode());
        String $fileVersion = this.getFileVersion();
        result = result * 59 + ($fileVersion == null ? 43 : $fileVersion.hashCode());
        String $contentUri = this.getContentUri();
        result = result * 59 + ($contentUri == null ? 43 : $contentUri.hashCode());
        String $checksum = this.getChecksum();
        result = result * 59 + ($checksum == null ? 43 : $checksum.hashCode());
        String $repositoryLocation = this.getRepositoryLocation();
        result = result * 59 + ($repositoryLocation == null ? 43 : $repositoryLocation.hashCode());
        String $versioningService = this.getVersioningService();
        result = result * 59 + ($versioningService == null ? 43 : $versioningService.hashCode());
        return result;
    }

    public String toString() {
        return "ContentElement(resourceId=" + this.getResourceId() + ", relativePath=" + this.getRelativePath() + ", fileVersion=" + this.getFileVersion() + ", contentLength=" + this.getContentLength() + ", contentUri=" + this.getContentUri() + ", checksum=" + this.getChecksum() + ", repositoryLocation=" + this.getRepositoryLocation() + ", versioningService=" + this.getVersioningService() + ")";
    }
}

