/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.entities.messaging;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.kit.datamanager.entities.messaging.IAMQPSubmittable;
import edu.kit.datamanager.exceptions.MessageValidationException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BasicMessage
implements IAMQPSubmittable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicMessage.class);
    private String principal;
    private String sender;
    private long timestamp;
    private String entityId;
    private Set<String> addressees = new HashSet<String>();
    private String action;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String subCategory;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<String, String> metadata = new HashMap<String, String>();

    @JsonIgnore
    public String getEntityName() {
        return "generic";
    }

    @Override
    @JsonIgnore
    public final String getRoutingKey() {
        String routingKey = this.getEntityName().toLowerCase() + "." + this.getAction().toLowerCase();
        if (this.getSubCategory() != null) {
            routingKey = routingKey + "." + this.getSubCategory().toLowerCase();
        }
        return routingKey;
    }

    @Override
    public void validate() {
        boolean valid = true;
        StringBuilder message = new StringBuilder();
        String mustNotBeNull = " must not be null!\n";
        if (this.getEntityName() == null) {
            valid = false;
            message.append("Entity name").append(mustNotBeNull);
        }
        if (this.getAction() == null) {
            valid = false;
            message.append("Action").append(mustNotBeNull);
        }
        if (this.getEntityId() == null) {
            valid = false;
            message.append("Entity id").append(mustNotBeNull);
        }
        if (!valid) {
            LOGGER.trace(message.toString());
            throw new MessageValidationException(message.toString());
        }
    }

    public final void setCurrentTimestamp() {
        this.setTimestamp(Instant.now().toDateTime(DateTimeZone.UTC).getMillis());
    }

    public static BasicMessage fromJson(String jsonString) throws IOException {
        return (BasicMessage)new ObjectMapper().readValue(jsonString, BasicMessage.class);
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getSender() {
        return this.sender;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public Set<String> getAddressees() {
        return this.addressees;
    }

    public String getAction() {
        return this.action;
    }

    public String getSubCategory() {
        return this.subCategory;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public void setAddressees(Set<String> addressees) {
        this.addressees = addressees;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setSubCategory(String subCategory) {
        this.subCategory = subCategory;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasicMessage)) {
            return false;
        }
        BasicMessage other = (BasicMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        String this$principal = this.getPrincipal();
        String other$principal = other.getPrincipal();
        if (this$principal == null ? other$principal != null : !this$principal.equals(other$principal)) {
            return false;
        }
        String this$sender = this.getSender();
        String other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !this$sender.equals(other$sender)) {
            return false;
        }
        String this$entityId = this.getEntityId();
        String other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        Set<String> this$addressees = this.getAddressees();
        Set<String> other$addressees = other.getAddressees();
        if (this$addressees == null ? other$addressees != null : !((Object)this$addressees).equals(other$addressees)) {
            return false;
        }
        String this$action = this.getAction();
        String other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        String this$subCategory = this.getSubCategory();
        String other$subCategory = other.getSubCategory();
        if (this$subCategory == null ? other$subCategory != null : !this$subCategory.equals(other$subCategory)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BasicMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        String $principal = this.getPrincipal();
        result = result * 59 + ($principal == null ? 43 : $principal.hashCode());
        String $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : $sender.hashCode());
        String $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        Set<String> $addressees = this.getAddressees();
        result = result * 59 + ($addressees == null ? 43 : ((Object)$addressees).hashCode());
        String $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        String $subCategory = this.getSubCategory();
        result = result * 59 + ($subCategory == null ? 43 : $subCategory.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    public String toString() {
        return "BasicMessage(principal=" + this.getPrincipal() + ", sender=" + this.getSender() + ", timestamp=" + this.getTimestamp() + ", entityId=" + this.getEntityId() + ", addressees=" + this.getAddressees() + ", action=" + this.getAction() + ", subCategory=" + this.getSubCategory() + ", metadata=" + this.getMetadata() + ")";
    }
}

