/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.entities.messaging;

import edu.kit.datamanager.entities.messaging.BasicMessage;
import java.util.HashMap;
import java.util.Map;

public class DataResourceMessage
extends BasicMessage {
    public static final String CONTENT_PATH_PROPERTY = "contentPath";
    public static final String CONTENT_URI_PROPERTY = "contentUri";
    public static final String CONTENT_TYPE_PROPERTY = "contentType";

    public static DataResourceMessage factoryCreateMessage(String dataResourceId, String caller, String sender) {
        return DataResourceMessage.createMessage(dataResourceId, ACTION.CREATE, caller, sender);
    }

    public static DataResourceMessage factoryUpdateMessage(String dataResourceId, String caller, String sender) {
        return DataResourceMessage.createMessage(dataResourceId, ACTION.UPDATE, caller, sender);
    }

    public static DataResourceMessage factoryFixMessage(String dataResourceId, String caller, String sender) {
        return DataResourceMessage.createMessage(dataResourceId, ACTION.FIX, caller, sender);
    }

    public static DataResourceMessage factoryRevokeMessage(String dataResourceId, String caller, String sender) {
        return DataResourceMessage.createMessage(dataResourceId, ACTION.REVOKE, caller, sender);
    }

    public static DataResourceMessage factoryDeleteMessage(String dataResourceId, String caller, String sender) {
        return DataResourceMessage.createMessage(dataResourceId, ACTION.DELETE, caller, sender);
    }

    public static DataResourceMessage factoryCreateDataMessage(String dataResourceId, String contentPath, String contentUri, String contentType, String caller, String sender) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(CONTENT_PATH_PROPERTY, contentPath);
        properties.put(CONTENT_URI_PROPERTY, contentUri);
        properties.put(CONTENT_TYPE_PROPERTY, contentType);
        return DataResourceMessage.createSubCategoryMessage(dataResourceId, ACTION.CREATE, SUB_CATEGORY.DATA, properties, caller, sender);
    }

    public static DataResourceMessage factoryUpdateDataMessage(String dataResourceId, String contentPath, String contentUri, String contentType, String caller, String sender) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(CONTENT_PATH_PROPERTY, contentPath);
        properties.put(CONTENT_URI_PROPERTY, contentUri);
        properties.put(CONTENT_TYPE_PROPERTY, contentType);
        return DataResourceMessage.createSubCategoryMessage(dataResourceId, ACTION.UPDATE, SUB_CATEGORY.DATA, properties, caller, sender);
    }

    public static DataResourceMessage factoryDeleteDataMessage(String dataResourceId, String contentPath, String contentUri, String contentType, String caller, String sender) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(CONTENT_PATH_PROPERTY, contentPath);
        properties.put(CONTENT_URI_PROPERTY, contentUri);
        properties.put(CONTENT_TYPE_PROPERTY, contentType);
        return DataResourceMessage.createSubCategoryMessage(dataResourceId, ACTION.DELETE, SUB_CATEGORY.DATA, properties, caller, sender);
    }

    public static DataResourceMessage factoryUpdateAclMessage(String dataResourceId, String caller, String sender) {
        return DataResourceMessage.createSubCategoryMessage(dataResourceId, ACTION.UPDATE, SUB_CATEGORY.ACL, null, caller, sender);
    }

    public static DataResourceMessage createMessage(String dataResourceId, ACTION action, String principal, String sender) {
        DataResourceMessage msg = new DataResourceMessage();
        msg.setEntityId(dataResourceId);
        msg.setAction(action.getValue());
        msg.setPrincipal(principal);
        msg.setSender(sender);
        msg.setCurrentTimestamp();
        return msg;
    }

    public static DataResourceMessage createSubCategoryMessage(String dataResourceId, ACTION action, SUB_CATEGORY subCategory, Map<String, String> properties, String principal, String sender) {
        DataResourceMessage msg = new DataResourceMessage();
        msg.setEntityId(dataResourceId);
        msg.setAction(action.getValue());
        msg.setSubCategory(subCategory.getValue());
        msg.setPrincipal(principal);
        msg.setSender(sender);
        if (properties != null) {
            msg.setMetadata(properties);
        }
        msg.setCurrentTimestamp();
        return msg;
    }

    @Override
    public String getEntityName() {
        return "dataresource";
    }

    public static void main(String[] args) throws Exception {
        DataResourceMessage msg = DataResourceMessage.factoryCreateMessage("test123", "me", "you");
        System.out.println(msg.toJson());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataResourceMessage)) {
            return false;
        }
        DataResourceMessage other = (DataResourceMessage)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DataResourceMessage;
    }

    @Override
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Override
    public String toString() {
        return "DataResourceMessage()";
    }

    public static enum SUB_CATEGORY {
        ACL("acl"),
        DATA("data");

        private final String value;

        private SUB_CATEGORY(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getValue();
        }
    }

    public static enum ACTION {
        CREATE("create"),
        UPDATE("update"),
        FIX("fix"),
        REVOKE("revoke"),
        DELETE("delete");

        private final String value;

        private ACTION(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getValue();
        }
    }
}

