/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.entities.messaging;

import edu.kit.datamanager.entities.messaging.BasicMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class PidRecordMessage
extends BasicMessage {
    public static final String RESOLVING_URL = "resolvingUrl";
    public static final String PID = "pid";

    @Override
    public String getEntityName() {
        return "pidrecord";
    }

    public static PidRecordMessage creation(String pid, String recordUrl, String principal, String sender) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(RESOLVING_URL, recordUrl);
        return PidRecordMessage.recordMessage(pid, properties, ACTION.ADD, Optional.empty(), principal, sender);
    }

    public static PidRecordMessage update(String pid, String recordUrl, String principal, String sender) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(RESOLVING_URL, recordUrl);
        return PidRecordMessage.recordMessage(pid, properties, ACTION.UPDATE, Optional.empty(), principal, sender);
    }

    public static PidRecordMessage recordMessage(String entityId, Map<String, String> properties, ACTION action, Optional<SUB_CATEGORY> subCategory, String principal, String sender) {
        PidRecordMessage msg = new PidRecordMessage();
        msg.setEntityId(entityId);
        msg.setAction(action.getValue());
        subCategory.map(sub -> {
            msg.setSubCategory(sub.getValue());
            return sub;
        });
        msg.setPrincipal(principal);
        msg.setSender(sender);
        if (properties != null) {
            msg.setMetadata(properties);
        }
        msg.setCurrentTimestamp();
        return msg;
    }

    @Override
    public String toString() {
        return "PidRecordMessage()";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PidRecordMessage)) {
            return false;
        }
        PidRecordMessage other = (PidRecordMessage)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PidRecordMessage;
    }

    @Override
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public static enum SUB_CATEGORY {
        PROFILE_TESTBED4INF("p_testbed"),
        PROFILE_HMC("p_hmc");

        private final String value;

        private SUB_CATEGORY(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getValue();
        }
    }

    public static enum ACTION {
        ADD("add"),
        UPDATE("update");

        private final String value;

        private ACTION(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getValue();
        }
    }
}

