/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.entities.repo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ContentInformation
implements Serializable {
    public static final MediaType CONTENT_INFORMATION_MEDIA_TYPE = MediaType.parseMediaType((String)"application/vnd.datamanager.content-information+json");
    private long id;
    private String relativePath;
    private String contentUri;
    private String uploader;
    private String mediaType;
    private String hash;
    private long size;
    private Map<String, String> metadata = new HashMap<String, String>();
    private Set<String> tags = new HashSet<String>();
    private InputStream contentStream;

    public String getFilename() {
        if (this.relativePath == null) {
            return null;
        }
        return this.relativePath.substring(this.relativePath.lastIndexOf("/") + 1);
    }

    @JsonIgnore
    public void setMediaTypeAsObject(MediaType mediaType) {
        if (mediaType == null) {
            throw new IllegalArgumentException("Argument must not be null.");
        }
        this.mediaType = mediaType.toString();
    }

    @JsonIgnore
    public MediaType getMediaTypeAsObject() {
        try {
            return MediaType.parseMediaType((String)this.mediaType);
        }
        catch (InvalidMediaTypeException ex) {
            return MediaType.APPLICATION_OCTET_STREAM;
        }
    }

    public long getId() {
        return this.id;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public String getContentUri() {
        return this.contentUri;
    }

    public String getUploader() {
        return this.uploader;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getHash() {
        return this.hash;
    }

    public long getSize() {
        return this.size;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public InputStream getContentStream() {
        return this.contentStream;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    public void setContentUri(String contentUri) {
        this.contentUri = contentUri;
    }

    public void setUploader(String uploader) {
        this.uploader = uploader;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public void setContentStream(InputStream contentStream) {
        this.contentStream = contentStream;
    }

    public String toString() {
        return "ContentInformation(id=" + this.getId() + ", relativePath=" + this.getRelativePath() + ", contentUri=" + this.getContentUri() + ", uploader=" + this.getUploader() + ", mediaType=" + this.getMediaType() + ", hash=" + this.getHash() + ", size=" + this.getSize() + ", metadata=" + this.getMetadata() + ", tags=" + this.getTags() + ", contentStream=" + this.getContentStream() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContentInformation)) {
            return false;
        }
        ContentInformation other = (ContentInformation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        String this$relativePath = this.getRelativePath();
        String other$relativePath = other.getRelativePath();
        if (this$relativePath == null ? other$relativePath != null : !this$relativePath.equals(other$relativePath)) {
            return false;
        }
        String this$contentUri = this.getContentUri();
        String other$contentUri = other.getContentUri();
        if (this$contentUri == null ? other$contentUri != null : !this$contentUri.equals(other$contentUri)) {
            return false;
        }
        String this$uploader = this.getUploader();
        String other$uploader = other.getUploader();
        if (this$uploader == null ? other$uploader != null : !this$uploader.equals(other$uploader)) {
            return false;
        }
        String this$mediaType = this.getMediaType();
        String other$mediaType = other.getMediaType();
        if (this$mediaType == null ? other$mediaType != null : !this$mediaType.equals(other$mediaType)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        InputStream this$contentStream = this.getContentStream();
        InputStream other$contentStream = other.getContentStream();
        return !(this$contentStream == null ? other$contentStream != null : !this$contentStream.equals(other$contentStream));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContentInformation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        long $size = this.getSize();
        result = result * 59 + (int)($size >>> 32 ^ $size);
        String $relativePath = this.getRelativePath();
        result = result * 59 + ($relativePath == null ? 43 : $relativePath.hashCode());
        String $contentUri = this.getContentUri();
        result = result * 59 + ($contentUri == null ? 43 : $contentUri.hashCode());
        String $uploader = this.getUploader();
        result = result * 59 + ($uploader == null ? 43 : $uploader.hashCode());
        String $mediaType = this.getMediaType();
        result = result * 59 + ($mediaType == null ? 43 : $mediaType.hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        InputStream $contentStream = this.getContentStream();
        result = result * 59 + ($contentStream == null ? 43 : $contentStream.hashCode());
        return result;
    }
}

