/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.handlers;

import edu.kit.datamanager.exceptions.ResourceElsewhereException;
import javax.persistence.EntityNotFoundException;
import org.hibernate.HibernateException;
import org.hibernate.exception.ConstraintViolationException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class RestResponseEntityExceptionHandler
extends ResponseEntityExceptionHandler {
    @ExceptionHandler(value={IllegalArgumentException.class, IllegalStateException.class})
    protected ResponseEntity<Object> handleBadRequest(RuntimeException ex, WebRequest request) {
        String bodyOfResponse = "Request contained an illegal argument or caused an illegal state after modifying a resource.";
        return this.handleExceptionInternal(ex, bodyOfResponse, new HttpHeaders(), HttpStatus.BAD_REQUEST, request);
    }

    @ExceptionHandler(value={EntityNotFoundException.class})
    protected ResponseEntity<Object> handleEntityNotFound(EntityNotFoundException ex, WebRequest request) {
        String bodyOfResponse = "Resource not found.";
        return this.handleExceptionInternal((Exception)ex, bodyOfResponse, new HttpHeaders(), HttpStatus.NOT_FOUND, request);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    protected ResponseEntity<Object> handleConstraintViolationException(ConstraintViolationException ex, WebRequest request) {
        return this.handleExceptionInternal((Exception)ex, ex.getLocalizedMessage(), new HttpHeaders(), HttpStatus.CONFLICT, request);
    }

    @ExceptionHandler(value={HibernateException.class})
    protected ResponseEntity<Object> handleHibernateException(HibernateException ex, WebRequest request) {
        return this.handleExceptionInternal((Exception)ex, ex.getLocalizedMessage(), new HttpHeaders(), HttpStatus.BAD_REQUEST, request);
    }

    @ExceptionHandler(value={ResourceElsewhereException.class})
    protected ResponseEntity<Object> handleResourceElsewhereException(ResourceElsewhereException ex, WebRequest request) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Location", ex.getMessage());
        return this.handleExceptionInternal((Exception)((Object)ex), ex.getLocalizedMessage(), headers, HttpStatus.SEE_OTHER, request);
    }
}

