/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.security.filter;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.kit.datamanager.entities.RepoUserRole;
import edu.kit.datamanager.exceptions.InvalidAuthenticationException;
import edu.kit.datamanager.security.filter.JwtEmptyToken;
import edu.kit.datamanager.security.filter.JwtServiceToken;
import edu.kit.datamanager.security.filter.JwtTemporaryToken;
import edu.kit.datamanager.security.filter.JwtUserToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public abstract class JwtAuthenticationToken
extends AbstractAuthenticationToken {
    private static final Logger LOGGER = LoggerFactory.getLogger(JwtAuthenticationToken.class);
    public static final String NOT_AVAILABLE = "N/A";
    private String principalName;
    private String groupId;
    private final String token;

    JwtAuthenticationToken(String token) {
        super((Collection)AuthorityUtils.NO_AUTHORITIES);
        this.token = token;
    }

    public JwtAuthenticationToken(String token, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.token = token;
    }

    public static JwtAuthenticationToken factoryToken(String token) {
        return new JwtEmptyToken(token);
    }

    public static JwtAuthenticationToken factoryToken(String token, Map<String, Object> claims) {
        String type = MapUtils.getString(claims, (Object)"tokenType");
        String roles = MapUtils.getString(claims, (Object)"roles");
        HashSet<String> roleSet = new HashSet<String>();
        if (roles == null) {
            LOGGER.warn("No 'roles' claim found in JWT " + claims + ". Using ROLE_GUEST as default.");
        } else {
            try {
                String[] rolesArray = (String[])new ObjectMapper().readValue(roles, String[].class);
                roleSet.addAll(Arrays.asList(rolesArray));
            }
            catch (IOException ex) {
                LOGGER.warn("Unable to deserialize 'roles' claim from JWT. Using ROLE_GUEST as default.");
            }
        }
        if (roleSet.isEmpty()) {
            roleSet.add(RepoUserRole.GUEST.getValue());
        }
        List<SimpleGrantedAuthority> grantedAuthorities = JwtAuthenticationToken.grantedAuthorities(new HashSet<String>(roleSet));
        JwtAuthenticationToken jwToken = null;
        switch (TOKEN_TYPE.fromString(type)) {
            case USER: {
                jwToken = new JwtUserToken(token, grantedAuthorities);
                break;
            }
            case SERVICE: {
                jwToken = new JwtServiceToken(token, grantedAuthorities);
                break;
            }
            case TEMPORARY: {
                jwToken = new JwtTemporaryToken(token, grantedAuthorities);
            }
        }
        if (jwToken == null) {
            throw new InvalidAuthenticationException("JWTokens of type " + type + " are currently not supported.");
        }
        for (String claim : jwToken.getSupportedClaims()) {
            Object value = MapUtils.getObject(claims, (Object)claim);
            Class c = jwToken.getClassForClaim(claim);
            if (value != null && !c.isInstance(value)) {
                throw new InvalidAuthenticationException("Claim " + claim + " is invalid. Expected type " + c);
            }
            jwToken.setValueFromClaim(claim, value);
        }
        jwToken.validateToken();
        jwToken.setAuthenticated(true);
        return jwToken;
    }

    public static List<SimpleGrantedAuthority> grantedAuthorities(Set<String> roles) {
        if (null == roles) {
            return new ArrayList<SimpleGrantedAuthority>();
        }
        return roles.stream().map(String::toString).map(SimpleGrantedAuthority::new).collect(Collectors.toList());
    }

    public abstract String[] getSupportedClaims();

    public abstract Class getClassForClaim(String var1);

    public abstract void setValueFromClaim(String var1, Object var2);

    public void validateToken() {
        if (this.getPrincipal() == null) {
            throw new InvalidAuthenticationException("Token validatation failed. No principal assigned.");
        }
        this.validate();
    }

    public abstract void validate() throws InvalidAuthenticationException;

    public abstract TOKEN_TYPE getTokenType();

    void setPrincipalName(String principalName) {
        this.principalName = principalName;
    }

    public Object getCredentials() {
        return NOT_AVAILABLE;
    }

    public final Object getPrincipal() {
        return this.principalName;
    }

    public final String getToken() {
        return this.token;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public final void setAuthenticated(boolean authenticated) {
        super.setAuthenticated(authenticated);
    }

    public static enum TOKEN_TYPE {
        USER,
        SERVICE,
        TEMPORARY,
        UNSUPPORTED;


        public static TOKEN_TYPE fromString(String value) {
            TOKEN_TYPE result = USER;
            try {
                if (value != null) {
                    result = TOKEN_TYPE.valueOf(value);
                }
            }
            catch (IllegalArgumentException ex) {
                result = UNSUPPORTED;
            }
            return result;
        }
    }
}

