/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.security.filter;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.kit.datamanager.entities.PERMISSION;
import edu.kit.datamanager.exceptions.InvalidAuthenticationException;
import edu.kit.datamanager.security.filter.JwtAuthenticationToken;
import edu.kit.datamanager.security.filter.ScopedPermission;
import java.io.IOException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;

public class JwtTemporaryToken
extends JwtAuthenticationToken {
    private static final Logger LOGGER = LoggerFactory.getLogger(JwtTemporaryToken.class);
    private ScopedPermission[] scopedPermissions = new ScopedPermission[0];

    public JwtTemporaryToken(String token, Collection<? extends GrantedAuthority> authorities) {
        super(token, authorities);
    }

    @Override
    public String[] getSupportedClaims() {
        return new String[]{"principalname", "permissions"};
    }

    @Override
    public Class getClassForClaim(String claim) {
        return String.class;
    }

    @Override
    public void setValueFromClaim(String claim, Object value) {
        switch (claim) {
            case "principalname": {
                this.setPrincipalName((String)value);
                break;
            }
            case "permissions": {
                this.parsePermissions((String)value);
                break;
            }
            default: {
                LOGGER.warn("Invalid claim {} with value {} received. Claim will be ignored.", (Object)claim, value);
            }
        }
    }

    @Override
    public void validate() throws InvalidAuthenticationException {
        if (this.scopedPermissions == null || this.scopedPermissions.length == 0) {
            throw new InvalidAuthenticationException("Invalid token. No permissions found.");
        }
        for (ScopedPermission permission : this.scopedPermissions) {
            if (!permission.getPermission().atLeast(PERMISSION.WRITE)) continue;
            LOGGER.info("Scoped permission for resource type {} and resource id {} has value {}. For security reasons it is highly recommended to grant only READ permissions for temporary access tokens.", new Object[]{permission.getResourceType(), permission.getResourceId(), permission.getPermission()});
        }
    }

    private void parsePermissions(String value) {
        if (value == null) {
            throw new InvalidAuthenticationException("Mandatory claim 'permissions' has value 'null'.");
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            this.scopedPermissions = (ScopedPermission[])mapper.readValue(value, ScopedPermission[].class);
        }
        catch (IOException ex) {
            throw new InvalidAuthenticationException("Failed to read scoped permissions from claim value " + value + ".");
        }
    }

    public ScopedPermission[] getScopedPermissions() {
        return this.scopedPermissions;
    }

    @Override
    public JwtAuthenticationToken.TOKEN_TYPE getTokenType() {
        return JwtAuthenticationToken.TOKEN_TYPE.TEMPORARY;
    }
}

