/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.security.filter;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.RemoteKeySourceException;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.source.ImmutableJWKSet;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.shaded.json.JSONArray;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import edu.kit.datamanager.security.filter.JwtAuthenticationToken;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakTokenValidator {
    private static final Logger LOG = LoggerFactory.getLogger(KeycloakTokenValidator.class);
    public static final String JWT_AUD = "aud";
    private String jwkUrl;
    private String resource;
    private String jwtClaim;
    private int connectTimeoutms = 0;
    private int readTimeoutms = 0;
    private int sizeLimit = 0;
    private boolean initialized = false;
    private String jwtLocalSecret = null;
    private ConfigurableJWTProcessor jwtProcessor;

    public void setJwtProcessor(ConfigurableJWTProcessor jwtProcessor) {
        this.jwtProcessor = jwtProcessor;
    }

    private JWSKeySelector keySelector(JWKSource keySource) {
        return new JWSVerificationKeySelector(JWSAlgorithm.RS256, keySource);
    }

    private void init() {
        if (this.jwkUrl != null) {
            LOG.info("Initializing JWK set from {}.", (Object)this.jwkUrl);
            try {
                JWKSet jwkSet = this.getJwkSet(this.jwkUrl);
                ImmutableJWKSet keySource = new ImmutableJWKSet(jwkSet);
                this.jwtProcessor.setJWSKeySelector(this.keySelector((JWKSource)keySource));
                LOG.info("JWK set initialized successfully.");
                this.initialized = true;
            }
            catch (IOException | ParseException e) {
                throw new RuntimeException("Failed to initialize KeycloakTokenValidator.", e);
            }
        }
    }

    public JWKSet getJwkSet(String jwkUrl) throws IOException, ParseException {
        return JWKSet.load((URL)new URL(jwkUrl), (int)this.connectTimeoutms, (int)this.readTimeoutms, (int)this.sizeLimit);
    }

    public JwtAuthenticationToken validate(String accessToken) throws BadJOSEException {
        SecurityContext ctx = null;
        try {
            JWTClaimsSet claimsSet = this.getJwtClaimsSet(accessToken, ctx);
            if (claimsSet != null) {
                List aud = claimsSet.getAudience();
                if (aud == null || !aud.contains(this.resource)) {
                    throw new BadJWTException("Invalid Keycloak Resource. Audience claim 'aud' is missing.");
                }
                JSONArray aRoles = null;
                Map o = claimsSet.getJSONObjectClaim("realm_access");
                if (o != null) {
                    aRoles = (JSONArray)o.get("roles");
                }
                if (aRoles == null) {
                    aRoles = new JSONArray();
                    aRoles.add((Object)"GUEST");
                }
                HashMap<String, Object> claims = new HashMap<String, Object>();
                String roles = aRoles.toJSONString();
                claims.put("username", claimsSet.getStringClaim(this.jwtClaim == null ? "preferred_user" : this.jwtClaim));
                claims.put("firstname", claimsSet.getStringClaim("given_name"));
                claims.put("lastname", claimsSet.getStringClaim("family_name"));
                claims.put("email", claimsSet.getStringClaim("email"));
                claims.put("roles", roles);
                JwtAuthenticationToken returnValue = null;
                returnValue = JwtAuthenticationToken.factoryToken(accessToken, claims);
                return returnValue;
            }
        }
        catch (RemoteKeySourceException e) {
            LOG.error("Failed to obtain remote key for JWT validation.", (Throwable)e);
        }
        catch (BadJWTException e) {
            LOG.warn("Invalid JWT received.", (Throwable)e);
        }
        catch (JOSEException | ParseException e) {
            LOG.error("Failed to parse JWT.", e);
        }
        return null;
    }

    private JWTClaimsSet getJwtClaimsSet(String accessToken, SecurityContext ctx) throws ParseException, BadJOSEException, JOSEException {
        return this.jwtProcessor.process(accessToken, ctx);
    }

    protected Jws<Claims> getJwsClaims(String accessToken) {
        return Jwts.parserBuilder().setSigningKey(this.jwtLocalSecret).build().parseClaimsJws(accessToken);
    }

    public boolean supportsLocalJwt() {
        return Objects.nonNull(this.jwtLocalSecret);
    }

    public boolean isValid() {
        return this.initialized;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        KeycloakTokenValidator accessTokenValidator = new KeycloakTokenValidator();

        private Builder() {
        }

        public Builder connectTimeout(int connectTimeout) {
            this.accessTokenValidator.connectTimeoutms = connectTimeout;
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.accessTokenValidator.readTimeoutms = readTimeout;
            return this;
        }

        public Builder sizeLimit(int sizeLimit) {
            this.accessTokenValidator.sizeLimit = sizeLimit;
            return this;
        }

        public Builder jwtProcessor(ConfigurableJWTProcessor jwtProcessor) {
            this.accessTokenValidator.jwtProcessor = jwtProcessor;
            return this;
        }

        public Builder jwtLocalSecret(String jwtLocalSecret) {
            this.accessTokenValidator.jwtLocalSecret = jwtLocalSecret;
            return this;
        }

        public KeycloakTokenValidator build(String jwksetUrl, String resource, String jwt_username_claim) {
            this.accessTokenValidator.resource = resource;
            this.accessTokenValidator.jwtClaim = jwt_username_claim;
            this.accessTokenValidator.jwkUrl = jwksetUrl;
            if (this.accessTokenValidator.jwtProcessor == null && jwksetUrl != null) {
                this.accessTokenValidator.jwtProcessor = (ConfigurableJWTProcessor)new DefaultJWTProcessor();
                this.accessTokenValidator.init();
            }
            return this.accessTokenValidator;
        }
    }
}

