/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.security.filter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.kit.datamanager.entities.RepoServiceRole;
import edu.kit.datamanager.exceptions.InvalidAuthenticationException;
import edu.kit.datamanager.security.filter.JwtAuthenticationToken;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.impl.DefaultClaims;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

public class NoAuthenticationFilter
extends OncePerRequestFilter {
    private final String secretKey;
    private final AuthenticationManager authenticationManager;

    public NoAuthenticationFilter(String secretKey, AuthenticationManager authenticationManager) {
        this.secretKey = secretKey;
        this.authenticationManager = authenticationManager;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException, AuthenticationException {
        DefaultClaims claims = new DefaultClaims();
        claims.put((Object)"groupid", (Object)"USERS");
        claims.put((Object)"tokenType", (Object)JwtAuthenticationToken.TOKEN_TYPE.SERVICE.toString());
        claims.put((Object)"servicename", (Object)"SELF");
        HashSet<String> rolesAsString = new HashSet<String>();
        rolesAsString.add(RepoServiceRole.SERVICE_WRITE.getValue());
        try {
            claims.put((Object)"roles", (Object)new ObjectMapper().writeValueAsString((Object)rolesAsString.toArray(new String[0])));
        }
        catch (JsonProcessingException ex) {
            throw new InvalidAuthenticationException("Failed to create JWToken.", ex);
        }
        Set claimEntries = claims.entrySet();
        HashMap<String, Object> claimMap = new HashMap<String, Object>();
        claimEntries.forEach(entry -> claimMap.put((String)entry.getKey(), entry.getValue()));
        String token = Jwts.builder().setClaims((Claims)claims).setExpiration(DateUtils.addHours((Date)new Date(), (int)1)).signWith(SignatureAlgorithm.HS256, this.secretKey).compact();
        JwtAuthenticationToken res = JwtAuthenticationToken.factoryToken(token, claimMap);
        SecurityContextHolder.getContext().setAuthentication((Authentication)res);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

