/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.kit.datamanager.entities.RepoRole;
import edu.kit.datamanager.entities.RepoUserRole;
import edu.kit.datamanager.security.filter.JwtAuthenticationToken;
import edu.kit.datamanager.security.filter.ScopedPermission;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.impl.DefaultClaims;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(JwtBuilder.class);
    private final Map<String, Object> claims;
    private final List<String> roles;
    private final List<ScopedPermission> permissions;
    private String principal;
    private JwtAuthenticationToken.TOKEN_TYPE type = JwtAuthenticationToken.TOKEN_TYPE.USER;

    JwtBuilder() {
        this.claims = new HashMap<String, Object>();
        this.roles = new ArrayList<String>();
        this.permissions = new ArrayList<ScopedPermission>();
    }

    public static JwtBuilder createUserToken(String userName, RepoRole ... roles) {
        JwtBuilder builder = new JwtBuilder();
        builder.setTokenType(JwtAuthenticationToken.TOKEN_TYPE.USER);
        builder.principal = userName;
        return builder.setRoles(roles);
    }

    public static JwtBuilder createServiceToken(String serviceName, RepoRole ... roles) {
        JwtBuilder builder = new JwtBuilder();
        builder.setTokenType(JwtAuthenticationToken.TOKEN_TYPE.SERVICE);
        builder.principal = serviceName;
        return builder.setRoles(roles);
    }

    public static JwtBuilder createTemporaryToken(String principalName, ScopedPermission ... permissions) {
        JwtBuilder builder = new JwtBuilder();
        builder.setTokenType(JwtAuthenticationToken.TOKEN_TYPE.TEMPORARY);
        builder.principal = principalName;
        return builder.setScopedPermissions(permissions);
    }

    private void setTokenType(JwtAuthenticationToken.TOKEN_TYPE type) {
        this.claims.put("tokenType", type.toString());
        this.type = type;
    }

    private JwtBuilder setRoles(RepoRole ... roles) {
        if (roles == null || this.type.equals((Object)JwtAuthenticationToken.TOKEN_TYPE.TEMPORARY)) {
            return this;
        }
        for (RepoRole role : roles) {
            this.roles.add(role.getValue());
        }
        return this;
    }

    private JwtBuilder setScopedPermissions(ScopedPermission ... permissions) {
        if (permissions == null || permissions.length == 0) {
            return this;
        }
        this.permissions.addAll(Arrays.asList(permissions));
        return this;
    }

    public JwtBuilder addSimpleClaim(String claimName, String value) {
        this.claims.put(claimName, value);
        return this;
    }

    public JwtBuilder addSimpleClaim(String claimName, Boolean value) {
        this.claims.put(claimName, value);
        return this;
    }

    public JwtBuilder addSimpleClaim(String claimName, Integer value) {
        this.claims.put(claimName, value);
        return this;
    }

    public Map<String, Object> getClaimMap() {
        try {
            switch (this.type) {
                case USER: {
                    String[] stringArray;
                    this.addSimpleClaim("username", this.principal);
                    ObjectMapper objectMapper = new ObjectMapper();
                    if (this.roles.isEmpty()) {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = RepoUserRole.GUEST.getValue();
                    } else {
                        stringArray = this.roles.toArray(new String[0]);
                    }
                    this.claims.put("roles", objectMapper.writeValueAsString((Object)stringArray));
                    break;
                }
                case SERVICE: {
                    String[] stringArray;
                    this.addSimpleClaim("servicename", this.principal);
                    ObjectMapper objectMapper = new ObjectMapper();
                    if (this.roles.isEmpty()) {
                        String[] stringArray3 = new String[1];
                        stringArray = stringArray3;
                        stringArray3[0] = RepoUserRole.GUEST.getValue();
                    } else {
                        stringArray = this.roles.toArray(new String[0]);
                    }
                    this.claims.put("roles", objectMapper.writeValueAsString((Object)stringArray));
                    break;
                }
                case TEMPORARY: {
                    this.addSimpleClaim("principalname", this.principal);
                    this.claims.put("permissions", new ObjectMapper().writeValueAsString((Object)this.permissions.toArray(new ScopedPermission[0])));
                }
            }
        }
        catch (JsonProcessingException ex) {
            LOGGER.warn("Failed to create claim map.", (Throwable)ex);
        }
        return this.claims;
    }

    public Claims getClaims() {
        DefaultClaims jwtClaims = new DefaultClaims();
        Map<String, Object> claimMap = this.getClaimMap();
        Set<Map.Entry<String, Object>> entries = claimMap.entrySet();
        entries.forEach(arg_0 -> JwtBuilder.lambda$getClaims$0((Claims)jwtClaims, arg_0));
        return jwtClaims;
    }

    public String getCompactToken(String secret) {
        return this.getCompactToken(secret, null);
    }

    public String getCompactToken(String secret, Date expiresAt) {
        if (expiresAt != null) {
            return Jwts.builder().setClaims(this.getClaims()).setExpiration(expiresAt).signWith(SignatureAlgorithm.HS256, secret).compact();
        }
        LOGGER.debug("Warn: Creating JWT token without expiration time.");
        return Jwts.builder().setClaims(this.getClaims()).signWith(SignatureAlgorithm.HS256, secret).compact();
    }

    public JwtAuthenticationToken getJwtAuthenticationToken(String secret) {
        return JwtAuthenticationToken.factoryToken(this.getCompactToken(secret), this.getClaimMap());
    }

    private static /* synthetic */ void lambda$getClaims$0(Claims jwtClaims, Map.Entry entry) {
        jwtClaims.put((Object)((String)entry.getKey()), entry.getValue());
    }
}

