/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.util.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomInstantDeserializer
extends JsonDeserializer<Instant> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomInstantDeserializer.class);
    private final DateTimeFormatter isoFormat = DateTimeFormatter.ISO_DATE_TIME.withZone(ZoneOffset.UTC);
    private final DateTimeFormatter[] additionalFormats = new DateTimeFormatter[]{new DateTimeFormatterBuilder().appendPattern("yyyy").parseDefaulting(ChronoField.MONTH_OF_YEAR, 1L).parseDefaulting(ChronoField.DAY_OF_MONTH, 1L).toFormatter(), DateTimeFormatter.ofPattern("yyyy-MM-dd"), new DateTimeFormatterBuilder().appendPattern("yyyy-MM").parseDefaulting(ChronoField.DAY_OF_MONTH, 1L).toFormatter()};

    public Instant deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String text = p.getText();
        if (text == null || text.length() == 0) {
            return null;
        }
        try {
            LOGGER.trace("Trying to parse date {} using ISO_DATE_TIME.", (Object)text);
            return Instant.from(this.isoFormat.parse(text)).truncatedTo(ChronoUnit.MILLIS);
        }
        catch (DateTimeParseException ex) {
            LOGGER.trace("Date {} is no ISO_DATE_TIME, trying alternatives.", (Object)text);
            for (DateTimeFormatter formatter : this.additionalFormats) {
                try {
                    LOGGER.trace("Parsing date {} using formatter {}.", (Object)text, (Object)formatter);
                    LocalDate date = LocalDate.from(formatter.parse(text));
                    return Instant.from(date.atStartOfDay(ZoneOffset.UTC).toInstant());
                }
                catch (DateTimeException ex2) {
                    LOGGER.trace("Date {} cannot be parsed using formatter {}.", (Object)text, (Object)formatter);
                }
            }
            throw new DateTimeParseException("Invalid date string. Supported format patterns are: yyyy-MM-dd'T'HH:mm:ss'Z', yyyy, yyyy-MM-dd and yyyy-MM", p.getText(), 0);
        }
    }
}

