/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.util.xml.converters;

import com.github.dozermapper.core.DozerConverter;
import com.github.dozermapper.core.Mapper;
import com.github.dozermapper.core.MapperAware;
import edu.kit.datamanager.entities.repo.Contributor;
import java.util.HashSet;
import org.datacite.schema.kernel_4.ContributorType;
import org.datacite.schema.kernel_4.Resource;

public class ContributorsConverter
extends DozerConverter<HashSet, Resource.Contributors>
implements MapperAware {
    private Mapper mapper;

    public ContributorsConverter() {
        super(HashSet.class, Resource.Contributors.class);
    }

    public Resource.Contributors convertTo(HashSet a, Resource.Contributors b) {
        Resource.Contributors result = new Resource.Contributors();
        for (Object o : a) {
            Contributor c = (Contributor)o;
            Resource.Contributors.Contributor contributor = new Resource.Contributors.Contributor();
            if (c.getUser().getFamilyName() != null && c.getUser().getGivenName() != null) {
                contributor.setContributorName(c.getUser().getFamilyName() + ", " + c.getUser().getGivenName());
            }
            contributor.setGivenName(c.getUser().getGivenName());
            contributor.setFamilyName(c.getUser().getGivenName());
            if (c.getContributionType() != null) {
                contributor.setContributorType(ContributorType.fromValue(c.getContributionType().getValue()));
            } else {
                contributor.setContributorType(ContributorType.OTHER);
            }
            result.getContributor().add(contributor);
        }
        return result;
    }

    public HashSet convertFrom(Resource.Contributors b, HashSet a) {
        return null;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }
}

