/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.validator;

import edu.kit.datamanager.annotations.ExecutableFileURL;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutableFileValidator
implements ConstraintValidator<ExecutableFileURL, URL> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutableFileValidator.class);

    public boolean isValid(URL value, ConstraintValidatorContext context) {
        boolean validExecutableFile = false;
        if (value == null) {
            LOGGER.error("Provided value is null.");
            return validExecutableFile;
        }
        try {
            LOGGER.trace("Successfully validated file URL {}. Checking local path.", (Object)value.toURI().toString());
            File executableFile = new File(value.getPath());
            String pathToExecutableFile = executableFile.getAbsolutePath();
            if (!executableFile.exists()) {
                LOGGER.error("File at {} does not exist!", (Object)pathToExecutableFile);
            } else if (!executableFile.isFile()) {
                LOGGER.error("File at {} is not a file!", (Object)pathToExecutableFile);
            } else if (!executableFile.canExecute()) {
                LOGGER.error("File at {} is not executable!", (Object)pathToExecutableFile);
            } else {
                LOGGER.trace("File at {} exists and is executable.", (Object)pathToExecutableFile);
                validExecutableFile = true;
            }
        }
        catch (URISyntaxException ex) {
            LOGGER.error("Failed to validate property with value " + value + ". -> Not a valid URL!", (Throwable)ex);
        }
        return validExecutableFile;
    }
}

