/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.impl;

import com.google.gson.reflect.TypeToken;
import edu.ksu.canvas.impl.BaseImpl;
import edu.ksu.canvas.interfaces.AccountReader;
import edu.ksu.canvas.interfaces.AccountWriter;
import edu.ksu.canvas.model.Account;
import edu.ksu.canvas.model.status.Delete;
import edu.ksu.canvas.net.Response;
import edu.ksu.canvas.net.RestClient;
import edu.ksu.canvas.oauth.OauthToken;
import edu.ksu.canvas.requestOptions.GetSubAccountsOptions;
import edu.ksu.canvas.requestOptions.ListAccountOptions;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountImpl
extends BaseImpl<Account, AccountReader, AccountWriter>
implements AccountReader,
AccountWriter {
    private static final Logger LOG = LoggerFactory.getLogger(AccountImpl.class);

    public AccountImpl(String canvasBaseUrl, Integer apiVersion, OauthToken oauthToken, RestClient restClient, int connectTimeout, int readTimeout, Integer paginationPageSize, Boolean serializeNulls) {
        super(canvasBaseUrl, apiVersion, oauthToken, restClient, connectTimeout, readTimeout, paginationPageSize, serializeNulls);
    }

    @Override
    public Optional<Account> getSingleAccount(String accountId) throws IOException {
        LOG.debug("getting account " + accountId);
        String url = this.buildCanvasUrl("accounts/" + accountId, Collections.emptyMap());
        Response response = this.canvasMessenger.getSingleResponseFromCanvas(this.oauthToken, url);
        if (response.getErrorHappened() || response.getResponseCode() != 200) {
            return Optional.empty();
        }
        return this.responseParser.parseToObject(Account.class, response);
    }

    @Override
    public List<Account> listAccounts(ListAccountOptions options) throws IOException {
        LOG.debug("Listing accounts for current user ");
        String url = this.buildCanvasUrl("accounts", options.getOptionsMap());
        return this.getListFromCanvas(url);
    }

    @Override
    public List<Account> getSubAccounts(GetSubAccountsOptions options) throws IOException {
        LOG.debug("Getting list of sub-accounts for account " + options.getAccountId());
        String url = this.buildCanvasUrl("accounts/" + options.getAccountId() + "/sub_accounts", options.getOptionsMap());
        return this.getListFromCanvas(url);
    }

    @Override
    public List<Account> listAccountsForCourseAdmins() throws IOException {
        LOG.debug("Getting list of accounts by admin course enrollments");
        String url = this.buildCanvasUrl("course_accounts", Collections.emptyMap());
        return this.getListFromCanvas(url);
    }

    @Override
    protected Type listType() {
        return new TypeToken<List<Account>>(){}.getType();
    }

    @Override
    protected Class<Account> objectType() {
        return Account.class;
    }

    @Override
    public Optional<Account> createAccount(String accountId, Account account) throws IOException {
        LOG.debug("creating account");
        String url = this.buildCanvasUrl("accounts/" + accountId + "/sub_accounts", Collections.emptyMap());
        Response response = this.canvasMessenger.sendJsonPostToCanvas(this.oauthToken, url, account.toJsonObject(this.serializeNulls));
        return this.responseParser.parseToObject(Account.class, response);
    }

    @Override
    public Optional<Account> updateAccount(Account account) throws IOException {
        LOG.debug("updating account");
        String url = this.buildCanvasUrl("accounts/" + account.getId(), Collections.emptyMap());
        Response response = this.canvasMessenger.sendJsonPutToCanvas(this.oauthToken, url, account.toJsonObject(this.serializeNulls));
        return this.responseParser.parseToObject(Account.class, response);
    }

    @Override
    public Boolean deleteAccount(String parentAccountId, String accountId) throws IOException {
        HashMap<String, List<String>> postParams = new HashMap<String, List<String>>();
        String deleteUrl = this.buildCanvasUrl("accounts/" + parentAccountId + "/sub_accounts/" + accountId, Collections.emptyMap());
        Response response = this.canvasMessenger.deleteFromCanvas(this.oauthToken, deleteUrl, postParams);
        LOG.debug("response " + response.toString());
        if (response.getErrorHappened() || response.getResponseCode() != 200) {
            LOG.debug("Failed to delete course, error message: " + response.toString());
            return false;
        }
        Optional<Delete> responseParsed = this.responseParser.parseToObject(Delete.class, response);
        return responseParsed.map(r -> r.getDelete()).orElse(false);
    }
}

