/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.impl;

import com.google.gson.reflect.TypeToken;
import edu.ksu.canvas.impl.BaseImpl;
import edu.ksu.canvas.interfaces.AssignmentGroupReader;
import edu.ksu.canvas.interfaces.AssignmentGroupWriter;
import edu.ksu.canvas.model.assignment.AssignmentGroup;
import edu.ksu.canvas.net.Response;
import edu.ksu.canvas.net.RestClient;
import edu.ksu.canvas.oauth.OauthToken;
import edu.ksu.canvas.requestOptions.DeleteAssignmentGroupOptions;
import edu.ksu.canvas.requestOptions.GetAssignmentGroupOptions;
import edu.ksu.canvas.requestOptions.ListAssignmentGroupOptions;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssignmentGroupImpl
extends BaseImpl<AssignmentGroup, AssignmentGroupReader, AssignmentGroupWriter>
implements AssignmentGroupReader,
AssignmentGroupWriter {
    private static final Logger LOG = LoggerFactory.getLogger(AssignmentGroupImpl.class);

    public AssignmentGroupImpl(String canvasBaseUrl, Integer apiVersion, OauthToken oauthToken, RestClient restClient, int connectTimeout, int readTimeout, Integer paginationPageSize, Boolean serializeNulls) {
        super(canvasBaseUrl, apiVersion, oauthToken, restClient, connectTimeout, readTimeout, paginationPageSize, serializeNulls);
    }

    @Override
    public Optional<AssignmentGroup> getAssignmentGroup(GetAssignmentGroupOptions options) throws IOException {
        LOG.debug("Fetching assignment group " + options.getAssignmentGroupId() + " from course " + options.getCourseId());
        String url = this.buildCanvasUrl("courses/" + options.getCourseId() + "/assignment_groups/" + options.getAssignmentGroupId(), options.getOptionsMap());
        return this.getFromCanvas(url);
    }

    @Override
    public List<AssignmentGroup> listAssignmentGroup(ListAssignmentGroupOptions options) throws IOException {
        LOG.debug("Listing assignment groups in course " + options.getCourseId());
        String url = this.buildCanvasUrl("courses/" + options.getCourseId() + "/assignment_groups", options.getOptionsMap());
        return this.getListFromCanvas(url);
    }

    @Override
    public Optional<AssignmentGroup> createAssignmentGroup(String courseId, AssignmentGroup assignmentGroup) throws IOException {
        if (StringUtils.isBlank((CharSequence)courseId)) {
            throw new IllegalArgumentException("Must supply a course ID when creating an assignment group");
        }
        LOG.debug("Creating new assignment group in course " + courseId + ", group name: " + assignmentGroup.getName());
        String url = this.buildCanvasUrl("courses/" + courseId + "/assignment_groups", Collections.emptyMap());
        Response response = this.canvasMessenger.sendToCanvas(this.oauthToken, url, assignmentGroup.toPostMap(this.serializeNulls));
        return this.responseParser.parseToObject(AssignmentGroup.class, response);
    }

    @Override
    public Optional<AssignmentGroup> editAssignmentGroup(String courseId, AssignmentGroup assignmentGroup) throws IOException {
        if (StringUtils.isBlank((CharSequence)courseId) || assignmentGroup == null || assignmentGroup.getId() == null || (long)assignmentGroup.getId().intValue() == 0L) {
            throw new IllegalArgumentException("Course ID and assignment group ID must be provided");
        }
        LOG.debug("Modifying assignment group " + assignmentGroup.getId() + " in course " + courseId);
        String url = this.buildCanvasUrl("courses/" + courseId + "/assignment_groups/" + assignmentGroup.getId(), Collections.emptyMap());
        Response response = this.canvasMessenger.putToCanvas(this.oauthToken, url, assignmentGroup.toPostMap(this.serializeNulls));
        return this.responseParser.parseToObject(AssignmentGroup.class, response);
    }

    @Override
    public Optional<AssignmentGroup> deleteAssignmentGroup(DeleteAssignmentGroupOptions options) throws IOException {
        LOG.debug("Deleting assignment group " + options.getAssignmentGroupId() + " from course " + options.getCourseId());
        String url = this.buildCanvasUrl("courses/" + options.getCourseId() + "/assignment_groups/" + options.getAssignmentGroupId(), options.getOptionsMap());
        Response response = this.canvasMessenger.deleteFromCanvas(this.oauthToken, url, Collections.emptyMap());
        return this.responseParser.parseToObject(AssignmentGroup.class, response);
    }

    @Override
    protected Type listType() {
        return new TypeToken<List<AssignmentGroup>>(){}.getType();
    }

    @Override
    protected Class<AssignmentGroup> objectType() {
        return AssignmentGroup.class;
    }
}

