/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.net.UrlEscapers;
import edu.ksu.canvas.impl.GsonResponseParser;
import edu.ksu.canvas.impl.RestCanvasMessenger;
import edu.ksu.canvas.interfaces.CanvasMessenger;
import edu.ksu.canvas.interfaces.CanvasReader;
import edu.ksu.canvas.interfaces.CanvasWriter;
import edu.ksu.canvas.interfaces.ResponseParser;
import edu.ksu.canvas.net.Response;
import edu.ksu.canvas.net.RestClient;
import edu.ksu.canvas.oauth.OauthToken;
import edu.ksu.canvas.util.CanvasURLBuilder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseImpl<T, READERTYPE extends CanvasReader, WRITERTYPE extends CanvasWriter>
implements CanvasReader<T, READERTYPE>,
CanvasWriter<T, WRITERTYPE> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseImpl.class);
    protected String canvasBaseUrl;
    protected Integer apiVersion;
    protected OauthToken oauthToken;
    protected ResponseParser responseParser;
    protected CanvasMessenger canvasMessenger;
    protected Consumer<List<T>> responseCallback;
    protected String masqueradeAs;
    protected String masqueradeType;
    protected Integer paginationPageSize;
    protected Boolean serializeNulls = false;

    public BaseImpl(String canvasBaseUrl, Integer apiVersion, OauthToken oauthToken, RestClient restClient, int connectTimeout, int readTimeout, Integer paginationPageSize, Boolean serializeNulls) {
        this.canvasBaseUrl = canvasBaseUrl;
        this.apiVersion = apiVersion;
        this.oauthToken = oauthToken;
        this.paginationPageSize = paginationPageSize;
        this.serializeNulls = BooleanUtils.isTrue((Boolean)serializeNulls);
        this.responseParser = new GsonResponseParser();
        this.canvasMessenger = new RestCanvasMessenger(connectTimeout, readTimeout, restClient);
    }

    protected Optional<T> getFromCanvas(String url) throws IOException {
        Response response = this.canvasMessenger.getSingleResponseFromCanvas(this.oauthToken, url);
        if (response.getErrorHappened() || response.getResponseCode() != 200) {
            LOG.warn("Error " + response.getResponseCode() + "on GET from url " + url);
            throw new IOException("Error accessing url " + url);
        }
        return this.responseParser.parseToObject(this.objectType(), response);
    }

    protected List<T> getListFromCanvas(String url) throws IOException {
        Consumer<Response> consumer = null;
        if (this.responseCallback != null) {
            consumer = response -> this.responseCallback.accept(this.responseParser.parseToList(this.listType(), (Response)response));
        }
        List<Response> responses = this.canvasMessenger.getFromCanvas(this.oauthToken, url, consumer);
        this.responseCallback = null;
        return this.parseListOfResponses(responses);
    }

    @Override
    public READERTYPE withCallback(Consumer<List<T>> responseReceivedCallBack) {
        this.responseCallback = responseReceivedCallBack;
        return (READERTYPE)this;
    }

    @Override
    public READERTYPE readAsCanvasUser(String masqueradeAs) {
        return this.readAsUser(masqueradeAs, "canvas_user_id");
    }

    @Override
    public READERTYPE readAsSisUser(String masqueradeAs) {
        return this.readAsUser(masqueradeAs, "sis_user_id");
    }

    private READERTYPE readAsUser(String masqueradeAs, String masqueradeType) {
        this.masqueradeAs = masqueradeAs;
        this.masqueradeType = masqueradeType;
        return (READERTYPE)this;
    }

    @Override
    public WRITERTYPE writeAsCanvasUser(String masqueradeAs) {
        return this.writeAsUser(masqueradeAs, "canvas_user_id");
    }

    @Override
    public WRITERTYPE writeAsSisUser(String masqueradeAs) {
        return this.writeAsUser(masqueradeAs, "sis_user_id");
    }

    private WRITERTYPE writeAsUser(String masqueradeAs, String masqueradeType) {
        this.masqueradeAs = masqueradeAs;
        this.masqueradeType = masqueradeType;
        return (WRITERTYPE)this;
    }

    protected String encode(String value) {
        return UrlEscapers.urlPathSegmentEscaper().escape(value);
    }

    protected String buildCanvasUrl(String canvasMethod, Map<String, List<String>> parameters) {
        HashMap<String, List<String>> allParameters = new HashMap<String, List<String>>();
        allParameters.putAll(parameters);
        if (StringUtils.isNotBlank((CharSequence)this.masqueradeAs)) {
            if ("canvas_user_id".equals(this.masqueradeType)) {
                allParameters.put("as_user_id", Arrays.asList(this.masqueradeAs));
            } else if ("sis_user_id".equals(this.masqueradeType)) {
                allParameters.put("as_user_id", Arrays.asList("sis_user_id:" + this.masqueradeAs));
            }
            this.masqueradeAs = null;
            this.masqueradeType = null;
        }
        if (this.paginationPageSize != null) {
            allParameters.put("per_page", Arrays.asList(this.paginationPageSize.toString()));
        }
        Map<String, List<String>> nonEmptyParams = this.stripEmptyParams(allParameters);
        String finalUrl = CanvasURLBuilder.buildCanvasUrl(this.canvasBaseUrl, this.apiVersion, canvasMethod, nonEmptyParams);
        return finalUrl;
    }

    private Map<String, List<String>> stripEmptyParams(Map<String, List<String>> parameters) {
        ImmutableMap.Builder paramsBuilder = ImmutableMap.builder();
        for (Map.Entry<String, List<String>> entry : parameters.entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            paramsBuilder.put((Object)entry.getKey(), entry.getValue());
        }
        return paramsBuilder.build();
    }

    private List<T> parseListResponse(Response response) {
        return this.responseParser.parseToList(this.listType(), response);
    }

    protected abstract Type listType();

    protected abstract Class<T> objectType();

    protected List<T> parseListOfResponses(List<Response> responses) {
        return responses.stream().map(this::parseListResponse).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

