/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.impl;

import com.google.gson.reflect.TypeToken;
import edu.ksu.canvas.impl.BaseImpl;
import edu.ksu.canvas.interfaces.CalendarReader;
import edu.ksu.canvas.interfaces.CalendarWriter;
import edu.ksu.canvas.model.CalendarEvent;
import edu.ksu.canvas.net.Response;
import edu.ksu.canvas.net.RestClient;
import edu.ksu.canvas.oauth.OauthToken;
import edu.ksu.canvas.requestOptions.DeleteCalendarEventOptions;
import edu.ksu.canvas.requestOptions.ListCalendarEventsOptions;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarEventImpl
extends BaseImpl<CalendarEvent, CalendarReader, CalendarWriter>
implements CalendarReader,
CalendarWriter {
    private static final Logger LOG = LoggerFactory.getLogger(CalendarEventImpl.class);

    public CalendarEventImpl(String canvasBaseUrl, Integer apiVersion, OauthToken oauthToken, RestClient restClient, int connectTimeout, int readTimeout, Integer paginationPageSize, Boolean serializeNulls) {
        super(canvasBaseUrl, apiVersion, oauthToken, restClient, connectTimeout, readTimeout, paginationPageSize, serializeNulls);
    }

    @Override
    protected Type listType() {
        return new TypeToken<List<CalendarEvent>>(){}.getType();
    }

    @Override
    protected Class<CalendarEvent> objectType() {
        return CalendarEvent.class;
    }

    @Override
    public List<CalendarEvent> listCurrentUserCalendarEvents(ListCalendarEventsOptions options) throws IOException {
        LOG.debug("List calendar events for current user");
        String url = this.buildCanvasUrl("calendar_events", options.getOptionsMap());
        return this.getListFromCanvas(url);
    }

    @Override
    public List<CalendarEvent> listCalendarEvents(String userId, ListCalendarEventsOptions options) throws IOException {
        LOG.debug("List calendar events for " + userId);
        String url = this.buildCanvasUrl("users/" + userId + "/calendar_events", options.getOptionsMap());
        return this.getListFromCanvas(url);
    }

    @Override
    public Optional<CalendarEvent> getCalendarEvent(Integer id) throws IOException {
        LOG.debug("Getting calendar event: " + id);
        String url = this.buildCanvasUrl("/calendar_events/" + id.toString(), Collections.emptyMap());
        return this.getFromCanvas(url);
    }

    @Override
    public Optional<CalendarEvent> deleteCalendarEvent(DeleteCalendarEventOptions options) throws IOException {
        LOG.debug("Deleting calendar event: " + options.getId());
        String url = this.buildCanvasUrl("/calendar_events/" + options.getId(), Collections.emptyMap());
        Response response = this.canvasMessenger.deleteFromCanvas(this.oauthToken, url, options.getOptionsMap());
        LOG.debug("response " + response.toString());
        if (response.getErrorHappened() || response.getResponseCode() != 200) {
            LOG.debug("Failed to delete assignment, error message: " + response.toString());
            return Optional.empty();
        }
        return this.responseParser.parseToObject(CalendarEvent.class, response);
    }

    @Override
    public Optional<CalendarEvent> createCalendarEvent(CalendarEvent calendarEvent) throws IOException {
        LOG.debug("Creating calendar event.");
        String url = this.buildCanvasUrl("calendar_events", Collections.emptyMap());
        Objects.requireNonNull(calendarEvent.getContextCode(), "contextCode must be set to create a calendar event.");
        Map<String, List<String>> parameters = calendarEvent.toPostMap(false);
        this.addChildData(calendarEvent, parameters);
        Response response = this.canvasMessenger.sendToCanvas(this.oauthToken, url, parameters);
        return this.responseParser.parseToObject(CalendarEvent.class, response);
    }

    @Override
    public Optional<CalendarEvent> editCalendarEvent(CalendarEvent calendarEvent) throws IOException {
        LOG.debug("Modify calendar event " + calendarEvent.getId());
        String url = this.buildCanvasUrl("calendar_events/" + calendarEvent.getId(), Collections.emptyMap());
        Map<String, List<String>> parameters = calendarEvent.toPostMap(false);
        this.addChildData(calendarEvent, parameters);
        Response response = this.canvasMessenger.putToCanvas(this.oauthToken, url, parameters);
        return this.responseParser.parseToObject(CalendarEvent.class, response);
    }

    private void addChildData(CalendarEvent calendarEvent, Map<String, List<String>> parameters) {
        List<CalendarEvent.ChildEvent> childEventsData = calendarEvent.getChildEventsData();
        if (childEventsData == null) {
            return;
        }
        for (int i = 0; i < childEventsData.size(); ++i) {
            CalendarEvent.ChildEvent childEvent = childEventsData.get(i);
            Map<String, List<String>> additional = childEvent.toPostMap(false);
            String newKey = "calendar_event[child_event_data][" + i + "]";
            additional.forEach((key, value) -> parameters.putIfAbsent(newKey + key, (List<String>)value));
        }
    }
}

