/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.impl;

import com.google.gson.reflect.TypeToken;
import edu.ksu.canvas.impl.BaseImpl;
import edu.ksu.canvas.interfaces.CommunicationChannelReader;
import edu.ksu.canvas.interfaces.CommunicationChannelWriter;
import edu.ksu.canvas.model.CommunicationChannel;
import edu.ksu.canvas.net.Response;
import edu.ksu.canvas.net.RestClient;
import edu.ksu.canvas.oauth.OauthToken;
import edu.ksu.canvas.requestOptions.CreateCommunicationChannelOptions;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommunicationChannelImpl
extends BaseImpl<CommunicationChannel, CommunicationChannelReader, CommunicationChannelWriter>
implements CommunicationChannelReader,
CommunicationChannelWriter {
    private static final Logger LOG = LoggerFactory.getLogger(CommunicationChannelImpl.class);

    public CommunicationChannelImpl(String canvasBaseUrl, Integer apiVersion, OauthToken oauthToken, RestClient restClient, int connectTimeout, int readTimeout, Integer paginationPageSize, Boolean serializeNulls) {
        super(canvasBaseUrl, apiVersion, oauthToken, restClient, connectTimeout, readTimeout, paginationPageSize, serializeNulls);
    }

    @Override
    public List<CommunicationChannel> getCommunicationChannelsForUser(String userId) throws IOException {
        LOG.debug("Retrieving communication channels for user id " + userId);
        String url = this.buildCanvasUrl(String.format("users/%s/communication_channels", userId), Collections.emptyMap());
        return this.getListFromCanvas(url);
    }

    @Override
    public Optional<CommunicationChannel> createCommunicationChannel(CreateCommunicationChannelOptions options) throws IOException {
        LOG.debug("Creating communication channel for user " + options.getUserId());
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{options.getUserId()})) {
            throw new IllegalArgumentException("User ID is required to create a communication channel");
        }
        String url = this.buildCanvasUrl(String.format("users/%s/communication_channels", options.getUserId()), Collections.emptyMap());
        Response response = this.canvasMessenger.sendToCanvas(this.oauthToken, url, options.getOptionsMap());
        return this.responseParser.parseToObject(CommunicationChannel.class, response);
    }

    @Override
    public Optional<CommunicationChannel> deleteCommunicationChannel(CommunicationChannel cc) throws IOException {
        LOG.debug(String.format("Deleting communication channel %s for user %s", cc.getId(), cc.getUserId()));
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{cc.getUserId(), cc.getId()})) {
            throw new IllegalArgumentException("User ID and communication channel ID are required to delete a communication channel");
        }
        String url = this.buildCanvasUrl(String.format("users/%s/communication_channels/%s", cc.getUserId(), cc.getId()), Collections.emptyMap());
        Response response = this.canvasMessenger.deleteFromCanvas(this.oauthToken, url, Collections.emptyMap());
        return this.responseParser.parseToObject(CommunicationChannel.class, response);
    }

    @Override
    protected Type listType() {
        return new TypeToken<List<CommunicationChannel>>(){}.getType();
    }

    @Override
    protected Class<CommunicationChannel> objectType() {
        return CommunicationChannel.class;
    }
}

