/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.impl;

import com.google.gson.reflect.TypeToken;
import edu.ksu.canvas.impl.BaseImpl;
import edu.ksu.canvas.interfaces.CourseReader;
import edu.ksu.canvas.interfaces.CourseSettingsReader;
import edu.ksu.canvas.interfaces.CourseSettingsWriter;
import edu.ksu.canvas.model.CourseSettings;
import edu.ksu.canvas.net.Response;
import edu.ksu.canvas.net.RestClient;
import edu.ksu.canvas.oauth.OauthToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CourseSettingsImpl
extends BaseImpl<CourseSettings, CourseSettingsReader, CourseSettingsWriter>
implements CourseSettingsReader,
CourseSettingsWriter {
    private static final Logger LOG = LoggerFactory.getLogger(CourseReader.class);

    public CourseSettingsImpl(String canvasBaseUrl, Integer apiVersion, OauthToken oauthToken, RestClient restClient, int connectTimeout, int readTimeout, Integer paginationPageSize, Boolean serializeNulls) {
        super(canvasBaseUrl, apiVersion, oauthToken, restClient, connectTimeout, readTimeout, paginationPageSize, serializeNulls);
    }

    @Override
    public Optional<CourseSettings> getCourseSettings(String courseId) throws IOException {
        LOG.debug("getting course settings for " + courseId);
        String url = this.buildCanvasUrl(String.format("courses/%s/settings", courseId), Collections.emptyMap());
        Response response = this.canvasMessenger.getSingleResponseFromCanvas(this.oauthToken, url);
        return this.responseParser.parseToObject(CourseSettings.class, response);
    }

    @Override
    public Optional<CourseSettings> updateCourseSettings(String courseId, CourseSettings settings) throws IOException {
        LOG.debug("updating course settings for " + courseId);
        String url = this.buildCanvasUrl(String.format("courses/%s/settings", courseId), Collections.emptyMap());
        Response response = this.canvasMessenger.putToCanvas(this.oauthToken, url, settings.toPostMap(this.serializeNulls));
        return this.responseParser.parseToObject(CourseSettings.class, response);
    }

    @Override
    protected Type listType() {
        return new TypeToken<List<CourseSettings>>(){}.getType();
    }

    @Override
    protected Class<CourseSettings> objectType() {
        return CourseSettings.class;
    }
}

