/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.impl;

import com.google.gson.reflect.TypeToken;
import edu.ksu.canvas.impl.BaseImpl;
import edu.ksu.canvas.interfaces.FeatureReader;
import edu.ksu.canvas.interfaces.FeatureWriter;
import edu.ksu.canvas.model.Feature;
import edu.ksu.canvas.net.RestClient;
import edu.ksu.canvas.oauth.OauthToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;

public class FeatureImpl
extends BaseImpl<Feature, FeatureReader, FeatureWriter>
implements FeatureReader {
    public FeatureImpl(String canvasBaseUrl, Integer apiVersion, OauthToken oauthToken, RestClient restClient, int connectTimeout, int readTimeout, Integer paginationPageSize, Boolean serializeNulls) {
        super(canvasBaseUrl, apiVersion, oauthToken, restClient, connectTimeout, readTimeout, paginationPageSize, serializeNulls);
    }

    @Override
    protected Type listType() {
        return new TypeToken<List<Feature>>(){}.getType();
    }

    @Override
    protected Class<Feature> objectType() {
        return Feature.class;
    }

    @Override
    public List<Feature> getCourseFeatures(String courseId) throws IOException {
        String url = this.buildCanvasUrl("courses/" + courseId + "/features", Collections.emptyMap());
        return this.getListFromCanvas(url);
    }

    @Override
    public List<Feature> getAccountFeatures(String accountId) throws IOException {
        String url = this.buildCanvasUrl("accounts/" + accountId + "/features", Collections.emptyMap());
        return this.getListFromCanvas(url);
    }

    @Override
    public List<Feature> getUserFeatures(String userId) throws IOException {
        String url = this.buildCanvasUrl("users/" + userId + "/features", Collections.emptyMap());
        return this.getListFromCanvas(url);
    }
}

