/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.impl;

import com.google.gson.reflect.TypeToken;
import edu.ksu.canvas.impl.BaseImpl;
import edu.ksu.canvas.interfaces.FileReader;
import edu.ksu.canvas.interfaces.FileWriter;
import edu.ksu.canvas.model.Deposit;
import edu.ksu.canvas.model.File;
import edu.ksu.canvas.net.RestClient;
import edu.ksu.canvas.oauth.OauthToken;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class FileImpl
extends BaseImpl<File, FileReader, FileWriter>
implements FileReader,
FileWriter {
    public FileImpl(String canvasBaseUrl, Integer apiVersion, OauthToken oauthToken, RestClient restClient, int connectTimeout, int readTimeout, Integer paginationPageSize, Boolean serializeNulls) {
        super(canvasBaseUrl, apiVersion, oauthToken, restClient, connectTimeout, readTimeout, paginationPageSize, serializeNulls);
    }

    @Override
    public Optional<File> upload(Deposit deposit, InputStream in, String filename) throws IOException {
        Map<String, List<String>> params = deposit.getUploadParams().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Collections.singletonList(e.getValue())));
        String location = this.canvasMessenger.sendUpload(deposit.getUploadUrl(), params, in, filename);
        return this.getFile(location);
    }

    @Override
    public Optional<File> getFile(String url) throws IOException {
        return this.getFromCanvas(url);
    }

    @Override
    protected Type listType() {
        return new TypeToken<List<File>>(){}.getType();
    }

    @Override
    protected Class<File> objectType() {
        return File.class;
    }
}

