/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.impl;

import com.google.gson.reflect.TypeToken;
import edu.ksu.canvas.impl.BaseImpl;
import edu.ksu.canvas.interfaces.LoginReader;
import edu.ksu.canvas.interfaces.LoginWriter;
import edu.ksu.canvas.model.Login;
import edu.ksu.canvas.net.Response;
import edu.ksu.canvas.net.RestClient;
import edu.ksu.canvas.oauth.OauthToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginImpl
extends BaseImpl<Login, LoginReader, LoginWriter>
implements LoginReader,
LoginWriter {
    private static final Logger LOG = LoggerFactory.getLogger(LoginImpl.class);

    public LoginImpl(String canvasBaseUrl, Integer apiVersion, OauthToken oauthToken, RestClient restClient, int connectTimeout, int readTimeout, Integer paginationPageSize, Boolean serializeNulls) {
        super(canvasBaseUrl, apiVersion, oauthToken, restClient, connectTimeout, readTimeout, paginationPageSize, serializeNulls);
    }

    @Override
    public List<Login> getLoginForUser(String userId) throws IOException {
        LOG.debug("Retrieving logins for user id " + userId);
        String url = this.buildCanvasUrl(String.format("users/%s/logins", userId), Collections.emptyMap());
        return this.getListFromCanvas(url);
    }

    @Override
    public Optional<Login> updateLogin(Login login) throws IOException {
        LOG.debug(String.format("Updating login %s on account %s", login.getId(), login.getAccountId()));
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{login.getAccountId(), login.getId()})) {
            throw new IllegalArgumentException("Account ID and Login ID are required to update a login");
        }
        String url = this.buildCanvasUrl(String.format("accounts/%s/logins/%s", login.getAccountId(), login.getId()), Collections.emptyMap());
        Response response = this.canvasMessenger.sendJsonPutToCanvas(this.oauthToken, url, login.toJsonObject(this.serializeNulls));
        return this.responseParser.parseToObject(Login.class, response);
    }

    @Override
    public Optional<Login> deleteLogin(Login login) throws IOException {
        LOG.debug(String.format("Deleting login %s for user %s", login.getId(), login.getUserId()));
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{login.getUserId(), login.getId()})) {
            throw new IllegalArgumentException("User ID and Login ID are required to delete a login");
        }
        String url = this.buildCanvasUrl(String.format("users/%s/logins/%s", login.getUserId(), login.getId()), Collections.emptyMap());
        Response response = this.canvasMessenger.deleteFromCanvas(this.oauthToken, url, Collections.emptyMap());
        return this.responseParser.parseToObject(Login.class, response);
    }

    @Override
    protected Type listType() {
        return new TypeToken<List<Login>>(){}.getType();
    }

    @Override
    protected Class<Login> objectType() {
        return Login.class;
    }
}

